<?php
/**
 * Staff Profile View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">My Profile</h1>
        <a href="<?php echo BASE_URL; ?>/staff" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Dashboard
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['form_errors'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul>
                <?php foreach ($_SESSION['form_errors'] as $error): ?>
                    <li><?php echo htmlspecialchars($error); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php unset($_SESSION['form_errors']); ?>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Profile Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Personal Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Personal Information</h2>
                <form action="<?php echo BASE_URL; ?>/staff/profile/update" method="POST">
                    <?php echo csrf_token(); ?>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">First Name</label>
                            <input type="text" name="first_name" required
                                   value="<?php echo htmlspecialchars($staff['first_name'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Last Name</label>
                            <input type="text" name="last_name" required
                                   value="<?php echo htmlspecialchars($staff['last_name'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Email</label>
                            <input type="email" name="email" required
                                   value="<?php echo htmlspecialchars($staff['email'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Phone</label>
                            <input type="tel" name="phone" required
                                   value="<?php echo htmlspecialchars($staff['phone'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700">Bio</label>
                            <textarea name="bio" rows="3" placeholder="Tell us about yourself..."
                                      class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($staff['bio'] ?? ''); ?></textarea>
                        </div>
                    </div>

                    <div class="mt-6">
                        <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                            Update Profile
                        </button>
                    </div>
                </form>
            </div>

            <!-- Professional Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Professional Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Employee ID</label>
                        <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($staff['employee_id'] ?? 'N/A'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Branch</label>
                        <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($staff['branch_name'] ?? 'Unassigned'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Role</label>
                        <p class="mt-1 text-gray-900"><?php echo ucfirst($staff['role'] ?? 'staff'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Status</label>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full mt-1
                            <?php echo ($staff['status'] ?? '') === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                            <?php echo ucfirst($staff['status'] ?? 'unknown'); ?>
                        </span>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Joined Date</label>
                        <p class="mt-1 text-gray-900"><?php echo $staff['created_at'] ? formatDate($staff['created_at']) : 'N/A'; ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Last Login</label>
                        <p class="mt-1 text-gray-900"><?php echo $staff['last_login'] ? formatDateTime($staff['last_login']) : 'Never'; ?></p>
                    </div>
                </div>
            </div>

            <!-- Services & Skills -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Services & Skills</h2>
                <?php if (!empty($services ?? [])): ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php foreach ($services as $service): ?>
                            <div class="border rounded-lg p-4">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <h3 class="font-medium"><?php echo htmlspecialchars($service['name']); ?></h3>
                                        <p class="text-sm text-gray-600"><?php echo htmlspecialchars($service['category_name'] ?? 'General'); ?></p>
                                        <?php if ($service['commission_rate']): ?>
                                            <p class="text-xs text-gray-500">Commission: <?php echo $service['commission_rate']; ?>%</p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($service['is_primary']): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                            Primary
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-gray-500">No services assigned yet.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Profile Picture -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Profile Picture</h3>
                <div class="text-center">
                    <div class="w-24 h-24 bg-indigo-500 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white text-2xl font-bold">
                            <?php echo strtoupper(substr($staff['first_name'] ?? 'U', 0, 1) . substr($staff['last_name'] ?? '', 0, 1)); ?>
                        </span>
                    </div>
                    <button class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 text-sm">
                        Change Photo
                    </button>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Quick Stats</h3>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Total Bookings</span>
                        <span class="text-sm font-medium"><?php echo number_format($stats['total_bookings'] ?? 0); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Completed</span>
                        <span class="text-sm font-medium"><?php echo number_format($stats['completed_bookings'] ?? 0); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Revenue</span>
                        <span class="text-sm font-medium">$<?php echo number_format($stats['total_revenue'] ?? 0, 2); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Avg Rating</span>
                        <span class="text-sm font-medium"><?php echo number_format($stats['avg_rating'] ?? 0, 1); ?> ⭐</span>
                    </div>
                </div>
            </div>

            <!-- Security Settings -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Security</h3>
                <div class="space-y-3">
                    <button onclick="changePassword()" class="w-full bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm">
                        Change Password
                    </button>
                    <button onclick="enable2FA()" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 text-sm">
                        Enable 2FA
                    </button>
                </div>
            </div>

            <!-- Availability Settings -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Schedule</h3>
                <a href="<?php echo BASE_URL; ?>/staff/schedule/availability" class="w-full bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-center block text-sm">
                    Manage Availability
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div id="passwordModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Change Password</h3>
            </div>
            <form id="passwordForm" class="p-6">
                <?php echo csrf_token(); ?>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Current Password</label>
                        <input type="password" id="current_password" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">New Password</label>
                        <input type="password" id="new_password" required minlength="8" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Confirm New Password</label>
                        <input type="password" id="confirm_password" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </div>
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" onclick="closePasswordModal()" class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-md hover:bg-gray-200">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-indigo-600 rounded-md hover:bg-indigo-700">Update Password</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function changePassword() {
    document.getElementById('passwordModal').classList.remove('hidden');
}

function closePasswordModal() {
    document.getElementById('passwordModal').classList.add('hidden');
    document.getElementById('passwordForm').reset();
}

document.getElementById('passwordForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const currentPassword = document.getElementById('current_password').value;
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('confirm_password').value;

    if (newPassword !== confirmPassword) {
        alert('New passwords do not match');
        return;
    }

    fetch('<?php echo BASE_URL; ?>/staff/profile/change-password', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `current_password=${encodeURIComponent(currentPassword)}&new_password=${encodeURIComponent(newPassword)}&csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            closePasswordModal();
            alert('Password changed successfully');
        } else {
            alert(data.message || 'Failed to change password');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to change password');
    });
});

function enable2FA() {
    alert('2FA setup coming soon!');
}
</script>
