<?php
/**
 * Staff Performance View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">My Performance</h1>
        <a href="<?php echo BASE_URL; ?>/staff" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Dashboard
        </a>
    </div>

    <!-- Performance Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Total Bookings</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($stats['total_bookings'] ?? 0); ?></p>
                    <p class="text-sm text-gray-500">This month</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Completion Rate</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($stats['completion_rate'] ?? 0, 1); ?>%</p>
                    <p class="text-sm text-gray-500">Completed bookings</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-yellow-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Revenue Generated</h3>
                    <p class="text-2xl font-bold text-gray-700">$<?php echo number_format($stats['total_revenue'] ?? 0, 2); ?></p>
                    <p class="text-sm text-gray-500">This month</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-purple-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Customer Rating</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($stats['avg_rating'] ?? 0, 1); ?> ⭐</p>
                    <p class="text-sm text-gray-500">Average rating</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Statistics -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Monthly Performance -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Monthly Performance</h2>
            <div class="space-y-4">
                <?php
                $monthlyStats = $monthlyStats ?? [
                    ['month' => 'January', 'bookings' => 45, 'revenue' => 2250.00],
                    ['month' => 'February', 'bookings' => 52, 'revenue' => 2600.00],
                    ['month' => 'March', 'bookings' => 48, 'revenue' => 2400.00],
                    ['month' => 'April', 'bookings' => 61, 'revenue' => 3050.00],
                    ['month' => 'May', 'bookings' => 55, 'revenue' => 2750.00],
                    ['month' => 'June', 'bookings' => 58, 'revenue' => 2900.00]
                ];

                foreach ($monthlyStats as $stat): ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium"><?php echo $stat['month']; ?></span>
                        <div class="text-right">
                            <span class="text-sm text-gray-600"><?php echo $stat['bookings']; ?> bookings</span>
                            <span class="text-sm font-medium ml-4">$<?php echo number_format($stat['revenue'], 0); ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Service Performance -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Service Performance</h2>
            <div class="space-y-4">
                <?php
                $serviceStats = $serviceStats ?? [
                    ['service' => 'Hair Styling', 'count' => 25, 'rating' => 4.8],
                    ['service' => 'Facial Treatment', 'count' => 18, 'rating' => 4.9],
                    ['service' => 'Massage', 'count' => 15, 'rating' => 4.7],
                    ['service' => 'Manicure', 'count' => 12, 'rating' => 4.6],
                    ['service' => 'Makeup', 'count' => 8, 'rating' => 4.9]
                ];

                foreach ($serviceStats as $stat): ?>
                    <div class="flex justify-between items-center">
                        <div>
                            <span class="text-sm font-medium"><?php echo htmlspecialchars($stat['service']); ?></span>
                            <span class="text-xs text-gray-500 ml-2">(<?php echo $stat['count']; ?> services)</span>
                        </div>
                        <div class="flex items-center">
                            <span class="text-sm font-medium mr-2"><?php echo number_format($stat['rating'], 1); ?></span>
                            <div class="flex">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <svg class="w-4 h-4 <?php echo $i <= $stat['rating'] ? 'text-yellow-400' : 'text-gray-300'; ?>" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Recent Feedback -->
    <div class="bg-white shadow rounded-lg p-6 mb-8">
        <h2 class="text-xl font-semibold mb-4">Recent Customer Feedback</h2>
        <div class="space-y-4">
            <?php
            $feedback = $feedback ?? [
                ['customer' => 'Sarah Johnson', 'service' => 'Hair Styling', 'rating' => 5, 'comment' => 'Amazing work! My hair looks fantastic and the service was excellent.', 'date' => '2024-01-15'],
                ['customer' => 'Mike Chen', 'service' => 'Massage', 'rating' => 5, 'comment' => 'Very relaxing session. The therapist was professional and attentive.', 'date' => '2024-01-12'],
                ['customer' => 'Emma Davis', 'service' => 'Facial', 'rating' => 4, 'comment' => 'Great facial treatment. My skin feels so much better!', 'date' => '2024-01-10'],
                ['customer' => 'John Smith', 'service' => 'Manicure', 'rating' => 5, 'comment' => 'Perfect manicure. Love the color and the attention to detail.', 'date' => '2024-01-08']
            ];

            foreach ($feedback as $item): ?>
                <div class="border rounded-lg p-4">
                    <div class="flex justify-between items-start mb-2">
                        <div>
                            <h4 class="font-medium"><?php echo htmlspecialchars($item['customer']); ?></h4>
                            <p class="text-sm text-gray-600"><?php echo htmlspecialchars($item['service']); ?> • <?php echo formatDate($item['date']); ?></p>
                        </div>
                        <div class="flex">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <svg class="w-4 h-4 <?php echo $i <= $item['rating'] ? 'text-yellow-400' : 'text-gray-300'; ?>" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            <?php endfor; ?>
                        </div>
                    </div>
                    <p class="text-gray-700 italic">"<?php echo htmlspecialchars($item['comment']); ?>"</p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Goals and Targets -->
    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-semibold mb-4">Monthly Goals</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-calendar-check text-2xl text-blue-600"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2">Bookings Goal</h3>
                <div class="text-3xl font-bold text-blue-600 mb-1">60</div>
                <div class="text-sm text-gray-600">Target: 50 completed</div>
                <div class="w-full bg-gray-200 rounded-full h-2 mt-2">
                    <div class="bg-blue-600 h-2 rounded-full" style="width: 83%"></div>
                </div>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-dollar-sign text-2xl text-green-600"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2">Revenue Goal</h3>
                <div class="text-3xl font-bold text-green-600 mb-1">$3,000</div>
                <div class="text-sm text-gray-600">Target: $2,500</div>
                <div class="w-full bg-gray-200 rounded-full h-2 mt-2">
                    <div class="bg-green-600 h-2 rounded-full" style="width: 87%"></div>
                </div>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-star text-2xl text-yellow-600"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2">Rating Goal</h3>
                <div class="text-3xl font-bold text-yellow-600 mb-1">4.8</div>
                <div class="text-sm text-gray-600">Target: 4.5+ stars</div>
                <div class="w-full bg-gray-200 rounded-full h-2 mt-2">
                    <div class="bg-yellow-600 h-2 rounded-full" style="width: 96%"></div>
                </div>
            </div>
        </div>
    </div>
</div>
