<?php
/**
 * Shop Order Details View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Order Details</h1>
        <a href="<?php echo BASE_URL; ?>/shop/orders" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Orders
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Order Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Order Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Order Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Order Number</label>
                        <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo htmlspecialchars($order['order_number']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Status</label>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full mt-1
                            <?php echo $order['status'] === 'delivered' ? 'bg-green-100 text-green-800' :
                                ($order['status'] === 'shipped' ? 'bg-blue-100 text-blue-800' :
                                ($order['status'] === 'processing' ? 'bg-yellow-100 text-yellow-800' :
                                ($order['status'] === 'pending' ? 'bg-gray-100 text-gray-800' :
                                'bg-red-100 text-red-800'))); ?>">
                            <?php echo ucfirst($order['status']); ?>
                        </span>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Order Date</label>
                        <p class="mt-1 text-gray-900"><?php echo formatDateTime($order['created_at']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Last Updated</label>
                        <p class="mt-1 text-gray-900"><?php echo formatDateTime($order['updated_at']); ?></p>
                    </div>
                </div>

                <?php if ($order['notes']): ?>
                    <div class="mt-4">
                        <label class="block text-sm font-medium text-gray-700">Order Notes</label>
                        <p class="mt-1 text-gray-600 bg-gray-50 p-3 rounded"><?php echo nl2br(htmlspecialchars($order['notes'])); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Order Items -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Order Items</h2>
                <div class="space-y-4">
                    <?php foreach ($orderItems ?? [] as $item): ?>
                        <div class="flex items-center space-x-4 border-b pb-4">
                            <div class="flex-shrink-0 w-16 h-16 bg-gray-200 rounded-md overflow-hidden">
                                <?php if ($item['images']): ?>
                                    <img src="<?php echo htmlspecialchars($item['images']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"
                                         class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full bg-gray-300 flex items-center justify-center">
                                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg font-medium text-gray-900">
                                    <a href="<?php echo BASE_URL; ?>/shop/products/<?php echo $item['slug'] ?? '#'; ?>" class="hover:text-indigo-600">
                                        <?php echo htmlspecialchars($item['name']); ?>
                                    </a>
                                </h3>
                                <p class="text-sm text-gray-600">Qty: <?php echo $item['quantity']; ?> × $<?php echo number_format($item['price'], 2); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-lg font-semibold text-gray-900">$<?php echo number_format($item['total'], 2); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Order Timeline -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Order Timeline</h2>
                <div class="space-y-4">
                    <?php
                    $timeline = $timeline ?? [
                        ['status' => 'Order Placed', 'date' => $order['created_at'], 'description' => 'Your order has been received and is being processed.'],
                        ['status' => 'Processing', 'date' => $order['updated_at'], 'description' => 'Your order is being prepared for shipment.']
                    ];

                    if ($order['status'] === 'shipped') {
                        $timeline[] = ['status' => 'Shipped', 'date' => $order['updated_at'], 'description' => 'Your order has been shipped and is on its way.'];
                    } elseif ($order['status'] === 'delivered') {
                        $timeline[] = ['status' => 'Shipped', 'date' => $order['updated_at'], 'description' => 'Your order has been shipped and is on its way.'];
                        $timeline[] = ['status' => 'Delivered', 'date' => $order['updated_at'], 'description' => 'Your order has been delivered successfully.'];
                    } elseif ($order['status'] === 'cancelled') {
                        $timeline[] = ['status' => 'Cancelled', 'date' => $order['updated_at'], 'description' => 'Your order has been cancelled.'];
                    }

                    foreach ($timeline as $event): ?>
                        <div class="flex items-start space-x-3">
                            <div class="flex-shrink-0">
                                <div class="w-2 h-2 bg-indigo-500 rounded-full mt-2"></div>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($event['status']); ?></p>
                                <p class="text-sm text-gray-600"><?php echo htmlspecialchars($event['description']); ?></p>
                                <p class="text-xs text-gray-500"><?php echo formatDateTime($event['date']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Order Summary & Actions -->
        <div class="space-y-6">
            <!-- Order Summary -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Order Summary</h3>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span>Subtotal</span>
                        <span>$<?php echo number_format($order['subtotal'], 2); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Tax</span>
                        <span>$<?php echo number_format($order['tax_amount'], 2); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Shipping</span>
                        <span>$<?php echo number_format($order['shipping_amount'], 2); ?></span>
                    </div>
                    <hr class="my-2">
                    <div class="flex justify-between text-lg font-semibold">
                        <span>Total</span>
                        <span>$<?php echo number_format($order['total_amount'], 2); ?></span>
                    </div>
                </div>
            </div>

            <!-- Shipping Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Shipping Address</h3>
                <?php $shipping = json_decode($order['shipping_address'], true); ?>
                <div class="text-sm text-gray-600">
                    <p class="font-medium text-gray-900"><?php echo htmlspecialchars($shipping['first_name'] . ' ' . $shipping['last_name']); ?></p>
                    <p><?php echo htmlspecialchars($shipping['address']); ?></p>
                    <p><?php echo htmlspecialchars($shipping['city'] . ', ' . $shipping['state'] . ' ' . $shipping['postal_code']); ?></p>
                    <p><?php echo htmlspecialchars($shipping['country']); ?></p>
                    <p><?php echo htmlspecialchars($shipping['phone']); ?></p>
                </div>
            </div>

            <!-- Billing Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Billing Address</h3>
                <?php $billing = json_decode($order['billing_address'], true); ?>
                <div class="text-sm text-gray-600">
                    <p class="font-medium text-gray-900"><?php echo htmlspecialchars($billing['first_name'] . ' ' . $billing['last_name']); ?></p>
                    <p><?php echo htmlspecialchars($billing['address']); ?></p>
                    <p><?php echo htmlspecialchars($billing['city'] . ', ' . $billing['state'] . ' ' . $billing['postal_code']); ?></p>
                    <p><?php echo htmlspecialchars($billing['country']); ?></p>
                    <p><?php echo htmlspecialchars($billing['phone']); ?></p>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Actions</h3>
                <div class="space-y-3">
                    <?php if (in_array($order['status'], ['pending', 'processing'])): ?>
                        <button onclick="cancelOrder(<?php echo $order['id']; ?>)" class="w-full bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700">
                            Cancel Order
                        </button>
                    <?php endif; ?>

                    <button onclick="reorder(<?php echo $order['id']; ?>)" class="w-full bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                        Reorder Items
                    </button>

                    <button onclick="printOrder()" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                        Print Order
                    </button>

                    <button onclick="contactSupport()" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                        Contact Support
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function cancelOrder(orderId) {
    if (!confirm('Are you sure you want to cancel this order? This action cannot be undone.')) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/shop/orders/${orderId}/cancel`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'Failed to cancel order');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to cancel order');
    });
}

function reorder(orderId) {
    if (!confirm('Add all items from this order to your cart?')) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/shop/orders/${orderId}/reorder`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = '<?php echo BASE_URL; ?>/shop/cart';
        } else {
            alert(data.message || 'Failed to reorder items');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to reorder items');
    });
}

function printOrder() {
    window.open(`<?php echo BASE_URL; ?>/shop/orders/<?php echo $order['id']; ?>/print`, '_blank');
}

function contactSupport() {
    window.location.href = '<?php echo BASE_URL; ?>/contact?subject=Order <?php echo htmlspecialchars($order['order_number']); ?>';
}
</script>
