<?php
/**
 * Shop Orders History View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Order History</h1>
        <a href="<?php echo BASE_URL; ?>/shop" class="text-indigo-600 hover:text-indigo-800">
            Continue Shopping
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <!-- Filters -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700">Status</label>
                <select name="status" onchange="this.form.submit()" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="all" <?php echo ($filters['status'] ?? 'all') === 'all' ? 'selected' : ''; ?>>All Orders</option>
                    <option value="pending" <?php echo ($filters['status'] ?? '') === 'pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="processing" <?php echo ($filters['status'] ?? '') === 'processing' ? 'selected' : ''; ?>>Processing</option>
                    <option value="shipped" <?php echo ($filters['status'] ?? '') === 'shipped' ? 'selected' : ''; ?>>Shipped</option>
                    <option value="delivered" <?php echo ($filters['status'] ?? '') === 'delivered' ? 'selected' : ''; ?>>Delivered</option>
                    <option value="cancelled" <?php echo ($filters['status'] ?? '') === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Date From</label>
                <input type="date" name="date_from" value="<?php echo $filters['date_from'] ?? ''; ?>" onchange="this.form.submit()"
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Date To</label>
                <input type="date" name="date_to" value="<?php echo $filters['date_to'] ?? ''; ?>" onchange="this.form.submit()"
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Search</label>
                <input type="text" name="search" value="<?php echo htmlspecialchars($filters['search'] ?? ''); ?>" placeholder="Order # or product..."
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div class="md:col-span-4 flex justify-end">
                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 mr-2">
                    Filter
                </button>
                <a href="<?php echo BASE_URL; ?>/shop/orders" class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                    Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Orders List -->
    <div class="space-y-6">
        <?php if (empty($orders ?? [])): ?>
            <div class="text-center py-12 bg-white shadow rounded-lg">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No orders found</h3>
                <p class="mt-1 text-sm text-gray-500">You haven't placed any orders yet.</p>
                <div class="mt-6">
                    <a href="<?php echo BASE_URL; ?>/shop" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                        Start Shopping
                    </a>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($orders as $order): ?>
                <div class="bg-white shadow rounded-lg overflow-hidden">
                    <!-- Order Header -->
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex justify-between items-center">
                            <div>
                                <h3 class="text-lg font-medium text-gray-900">Order #<?php echo htmlspecialchars($order['order_number']); ?></h3>
                                <p class="text-sm text-gray-600">Placed on <?php echo formatDateTime($order['created_at']); ?></p>
                            </div>
                            <div class="text-right">
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php echo $order['status'] === 'delivered' ? 'bg-green-100 text-green-800' :
                                        ($order['status'] === 'shipped' ? 'bg-blue-100 text-blue-800' :
                                        ($order['status'] === 'processing' ? 'bg-yellow-100 text-yellow-800' :
                                        ($order['status'] === 'pending' ? 'bg-gray-100 text-gray-800' :
                                        'bg-red-100 text-red-800'))); ?>">
                                    <?php echo ucfirst($order['status']); ?>
                                </span>
                                <p class="text-lg font-semibold text-gray-900 mt-1">$<?php echo number_format($order['total_amount'], 2); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Order Items -->
                    <div class="px-6 py-4">
                        <div class="space-y-4">
                            <?php foreach ($order['items'] ?? [] as $item): ?>
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0 w-16 h-16 bg-gray-200 rounded-md overflow-hidden">
                                        <?php if ($item['images']): ?>
                                            <img src="<?php echo htmlspecialchars($item['images']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"
                                                 class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <div class="w-full h-full bg-gray-300 flex items-center justify-center">
                                                <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                                </svg>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-1">
                                        <h4 class="text-sm font-medium text-gray-900">
                                            <a href="<?php echo BASE_URL; ?>/shop/products/<?php echo $item['slug'] ?? '#'; ?>" class="hover:text-indigo-600">
                                                <?php echo htmlspecialchars($item['name']); ?>
                                            </a>
                                        </h4>
                                        <p class="text-sm text-gray-600">Qty: <?php echo $item['quantity']; ?> × $<?php echo number_format($item['price'], 2); ?></p>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-medium text-gray-900">$<?php echo number_format($item['total'], 2); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <!-- Order Footer -->
                    <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
                        <div class="flex justify-between items-center">
                            <div class="flex space-x-4">
                                <a href="<?php echo BASE_URL; ?>/shop/orders/<?php echo $order['id']; ?>" class="text-indigo-600 hover:text-indigo-800 text-sm font-medium">
                                    View Details
                                </a>
                                <?php if (in_array($order['status'], ['pending', 'processing'])): ?>
                                    <button onclick="cancelOrder(<?php echo $order['id']; ?>)" class="text-red-600 hover:text-red-800 text-sm font-medium">
                                        Cancel Order
                                    </button>
                                <?php endif; ?>
                                <button onclick="reorder(<?php echo $order['id']; ?>)" class="text-green-600 hover:text-green-800 text-sm font-medium">
                                    Reorder
                                </button>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-gray-600">Total: <span class="font-semibold">$<?php echo number_format($order['total_amount'], 2); ?></span></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

            <!-- Pagination -->
            <?php if (($pagination['total_pages'] ?? 1) > 1): ?>
                <div class="flex justify-center mt-8">
                    <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px">
                        <?php if (($pagination['current_page'] ?? 1) > 1): ?>
                            <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => ($pagination['current_page'] ?? 1) - 1])); ?>"
                               class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                Previous
                            </a>
                        <?php endif; ?>

                        <?php for ($i = max(1, ($pagination['current_page'] ?? 1) - 2); $i <= min($pagination['total_pages'] ?? 1, ($pagination['current_page'] ?? 1) + 2); $i++): ?>
                            <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>"
                               class="relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium <?php echo $i === ($pagination['current_page'] ?? 1) ? 'text-indigo-600 bg-indigo-50' : 'text-gray-700 hover:bg-gray-50'; ?>">
                                <?php echo $i; ?>
                            </a>
                        <?php endfor; ?>

                        <?php if (($pagination['current_page'] ?? 1) < ($pagination['total_pages'] ?? 1)): ?>
                            <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => ($pagination['current_page'] ?? 1) + 1])); ?>"
                               class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                Next
                            </a>
                        <?php endif; ?>
                    </nav>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<script>
function cancelOrder(orderId) {
    if (!confirm('Are you sure you want to cancel this order? This action cannot be undone.')) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/shop/orders/${orderId}/cancel`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'Failed to cancel order');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to cancel order');
    });
}

function reorder(orderId) {
    if (!confirm('Add all items from this order to your cart?')) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/shop/orders/${orderId}/reorder`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = '<?php echo BASE_URL; ?>/shop/cart';
        } else {
            alert(data.message || 'Failed to reorder items');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to reorder items');
    });
}
</script>
