<?php
/**
 * Shop Checkout Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Checkout</h1>
        <a href="<?php echo BASE_URL; ?>/shop/cart" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Cart
        </a>
    </div>

    <?php if (isset($_SESSION['form_errors'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul>
                <?php foreach ($_SESSION['form_errors'] as $error): ?>
                    <li><?php echo htmlspecialchars($error); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php unset($_SESSION['form_errors']); ?>
    <?php endif; ?>

    <form action="<?php echo BASE_URL; ?>/shop/checkout/process" method="POST" class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <?php echo csrf_token(); ?>

        <!-- Left Column - Shipping & Billing -->
        <div class="space-y-6">
            <!-- Shipping Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Shipping Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">First Name *</label>
                        <input type="text" name="shipping_first_name" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_first_name'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Last Name *</label>
                        <input type="text" name="shipping_last_name" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_last_name'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Email *</label>
                        <input type="email" name="shipping_email" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_email'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Phone *</label>
                        <input type="tel" name="shipping_phone" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_phone'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Address *</label>
                        <input type="text" name="shipping_address" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_address'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">City *</label>
                        <input type="text" name="shipping_city" required
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_city'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">State/Province</label>
                        <input type="text" name="shipping_state"
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_state'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Postal Code</label>
                        <input type="text" name="shipping_postal_code"
                               value="<?php echo htmlspecialchars($_SESSION['form_data']['shipping_postal_code'] ?? ''); ?>"
                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Country *</label>
                        <select name="shipping_country" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select Country</option>
                            <option value="US" <?php echo ($_SESSION['form_data']['shipping_country'] ?? '') === 'US' ? 'selected' : ''; ?>>United States</option>
                            <option value="CA" <?php echo ($_SESSION['form_data']['shipping_country'] ?? '') === 'CA' ? 'selected' : ''; ?>>Canada</option>
                            <option value="GB" <?php echo ($_SESSION['form_data']['shipping_country'] ?? '') === 'GB' ? 'selected' : ''; ?>>United Kingdom</option>
                            <!-- Add more countries as needed -->
                        </select>
                    </div>
                </div>
            </div>

            <!-- Billing Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="same_address" id="same_address" onchange="toggleBillingAddress()"
                           <?php echo isset($_SESSION['form_data']['same_address']) ? 'checked' : 'checked'; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label for="same_address" class="ml-2 text-sm text-gray-700">Billing address is same as shipping</label>
                </div>

                <div id="billing_section" class="hidden">
                    <h3 class="text-lg font-medium mb-4">Billing Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">First Name *</label>
                            <input type="text" name="billing_first_name"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_first_name'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Last Name *</label>
                            <input type="text" name="billing_last_name"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_last_name'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Email *</label>
                            <input type="email" name="billing_email"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_email'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Phone *</label>
                            <input type="tel" name="billing_phone"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_phone'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700">Address *</label>
                            <input type="text" name="billing_address"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_address'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">City *</label>
                            <input type="text" name="billing_city"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_city'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">State/Province</label>
                            <input type="text" name="billing_state"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_state'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Postal Code</label>
                            <input type="text" name="billing_postal_code"
                                   value="<?php echo htmlspecialchars($_SESSION['form_data']['billing_postal_code'] ?? ''); ?>"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Country *</label>
                            <select name="billing_country" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Select Country</option>
                                <option value="US" <?php echo ($_SESSION['form_data']['billing_country'] ?? '') === 'US' ? 'selected' : ''; ?>>United States</option>
                                <option value="CA" <?php echo ($_SESSION['form_data']['billing_country'] ?? '') === 'CA' ? 'selected' : ''; ?>>Canada</option>
                                <option value="GB" <?php echo ($_SESSION['form_data']['billing_country'] ?? '') === 'GB' ? 'selected' : ''; ?>>United Kingdom</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Payment Method</h2>
                <div class="space-y-4">
                    <?php foreach ($paymentMethods as $method): ?>
                        <div class="flex items-center">
                            <input type="radio" name="payment_method_id" value="<?php echo $method['id']; ?>" required
                                   <?php echo ($_SESSION['form_data']['payment_method_id'] ?? '') == $method['id'] ? 'checked' : ''; ?>
                                   class="border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <label class="ml-3 text-sm font-medium text-gray-700">
                                <?php echo htmlspecialchars($method['name']); ?>
                                <?php if ($method['description']): ?>
                                    <span class="text-gray-500">- <?php echo htmlspecialchars($method['description']); ?></span>
                                <?php endif; ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Order Notes -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Order Notes (Optional)</h2>
                <textarea name="notes" rows="3" placeholder="Any special instructions for your order..."
                          class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($_SESSION['form_data']['notes'] ?? ''); ?></textarea>
            </div>
        </div>

        <!-- Right Column - Order Summary -->
        <div>
            <div class="bg-white shadow rounded-lg p-6 sticky top-6">
                <h2 class="text-xl font-semibold mb-4">Order Summary</h2>

                <!-- Cart Items -->
                <div class="space-y-4 mb-4">
                    <?php foreach ($cartItems as $item): ?>
                        <div class="flex items-center space-x-4">
                            <div class="flex-shrink-0 w-16 h-16 bg-gray-200 rounded-md overflow-hidden">
                                <?php if ($item['images']): ?>
                                    <img src="<?php echo htmlspecialchars($item['images']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"
                                         class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full bg-gray-300 flex items-center justify-center">
                                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($item['name']); ?></h3>
                                <p class="text-sm text-gray-600">Qty: <?php echo $item['quantity']; ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-gray-900">$<?php echo number_format($item['total_price'], 2); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <hr class="my-4">

                <!-- Order Totals -->
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span>Subtotal</span>
                        <span>$<?php echo number_format($subtotal, 2); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Tax</span>
                        <span>$<?php echo number_format($tax, 2); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Shipping</span>
                        <span><?php echo $shipping > 0 ? '$' . number_format($shipping, 2) : 'FREE'; ?></span>
                    </div>
                    <hr class="my-2">
                    <div class="flex justify-between text-lg font-semibold">
                        <span>Total</span>
                        <span>$<?php echo number_format($total, 2); ?></span>
                    </div>
                </div>

                <button type="submit" class="w-full mt-6 bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700 text-lg font-medium">
                    Complete Order
                </button>

                <p class="text-xs text-gray-600 mt-2 text-center">
                    By completing this order, you agree to our terms of service and privacy policy.
                </p>
            </div>
        </div>
    </form>

    <?php unset($_SESSION['form_data']); ?>
</div>

<script>
function toggleBillingAddress() {
    const checkbox = document.getElementById('same_address');
    const billingSection = document.getElementById('billing_section');

    if (checkbox.checked) {
        billingSection.classList.add('hidden');
    } else {
        billingSection.classList.remove('hidden');
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleBillingAddress();
});
</script>
