<?php
/**
 * Shop Product Detail View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <!-- Breadcrumbs -->
    <nav class="flex mb-8" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?php echo BASE_URL; ?>/shop" class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-indigo-600">
                    <svg class="w-3 h-3 mr-2.5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2A1 1 0 0 0 1 10h2v6a3 3 0 0 0 3 3h2a1 1 0 0 0 1-1v-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 0 1 1h2a3 3 0 0 0 3-3v-6h2a1 1 0 0 1 .707.293Z"/>
                    </svg>
                    Shop
                </a>
            </li>
            <?php if ($product['category_name']): ?>
                <li>
                    <div class="flex items-center">
                        <svg class="w-3 h-3 text-gray-400 mx-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m9 5 7 7-7 7"></path>
                        </svg>
                        <a href="<?php echo BASE_URL; ?>/shop/categories/<?php echo urlencode($product['category_slug']); ?>" class="text-sm font-medium text-gray-700 hover:text-indigo-600">
                            <?php echo htmlspecialchars($product['category_name']); ?>
                        </a>
                    </div>
                </li>
            <?php endif; ?>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-3 h-3 text-gray-400 mx-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m9 5 7 7-7 7"></path>
                    </svg>
                    <span class="text-sm font-medium text-gray-500"><?php echo htmlspecialchars($product['name']); ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">
        <!-- Product Images -->
        <div class="space-y-4">
            <?php if (!empty($images)): ?>
                <!-- Main Image -->
                <div class="aspect-w-1 aspect-h-1 bg-gray-200 rounded-lg overflow-hidden">
                    <img id="main-image" src="<?php echo htmlspecialchars($images[0]); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>"
                         class="w-full h-full object-cover">
                </div>
                <!-- Thumbnail Images -->
                <?php if (count($images) > 1): ?>
                    <div class="grid grid-cols-4 gap-2">
                        <?php foreach ($images as $index => $image): ?>
                            <button onclick="changeImage('<?php echo htmlspecialchars($image); ?>')"
                                    class="aspect-w-1 aspect-h-1 bg-gray-200 rounded-lg overflow-hidden border-2 <?php echo $index === 0 ? 'border-indigo-500' : 'border-gray-200'; ?>">
                                <img src="<?php echo htmlspecialchars($image); ?>" alt="Product image <?php echo $index + 1; ?>"
                                     class="w-full h-full object-cover">
                            </button>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="aspect-w-1 aspect-h-1 bg-gradient-to-br from-indigo-100 to-purple-100 rounded-lg flex items-center justify-center">
                    <svg class="w-24 h-24 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                    </svg>
                </div>
            <?php endif; ?>
        </div>

        <!-- Product Information -->
        <div class="space-y-6">
            <div>
                <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo htmlspecialchars($product['name']); ?></h1>
                <?php if ($product['category_name']): ?>
                    <p class="text-sm text-indigo-600 font-medium"><?php echo htmlspecialchars($product['category_name']); ?></p>
                <?php endif; ?>
                <div class="flex items-center mt-2">
                    <span class="text-3xl font-bold text-gray-900">$<?php echo number_format($product['price'], 2); ?></span>
                    <?php if ($product['sale_price'] && $product['sale_price'] < $product['price']): ?>
                        <span class="ml-3 text-lg text-gray-500 line-through">$<?php echo number_format($product['price'], 2); ?></span>
                        <span class="ml-2 inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                            Save $<?php echo number_format($product['price'] - $product['sale_price'], 2); ?>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Stock Status -->
            <div class="flex items-center">
                <?php if ($product['stock_quantity'] === null || $product['stock_quantity'] > 0): ?>
                    <div class="flex items-center text-green-600">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        In Stock
                        <?php if ($product['stock_quantity'] !== null): ?>
                            <span class="ml-1">(<?php echo $product['stock_quantity']; ?> available)</span>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="flex items-center text-red-600">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        Out of Stock
                    </div>
                <?php endif; ?>
            </div>

            <!-- Add to Cart Form -->
            <?php if ($product['stock_quantity'] === null || $product['stock_quantity'] > 0): ?>
                <form action="<?php echo BASE_URL; ?>/shop/cart/add" method="POST" class="space-y-4">
                    <?php echo csrf_token(); ?>
                    <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Quantity</label>
                        <div class="flex items-center space-x-3">
                            <button type="button" onclick="updateQuantity(-1)" class="bg-gray-200 text-gray-600 px-3 py-2 rounded-md hover:bg-gray-300">-</button>
                            <input type="number" name="quantity" id="quantity" value="1" min="1" max="<?php echo $product['stock_quantity'] ?? 99; ?>"
                                   class="w-20 text-center rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <button type="button" onclick="updateQuantity(1)" class="bg-gray-200 text-gray-600 px-3 py-2 rounded-md hover:bg-gray-300">+</button>
                        </div>
                    </div>

                    <button type="submit" class="w-full bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700 text-lg font-medium">
                        Add to Cart - $<?php echo number_format($product['price'], 2); ?>
                    </button>
                </form>
            <?php else: ?>
                <div class="bg-gray-100 border border-gray-200 rounded-md p-4">
                    <p class="text-gray-600 text-center">This product is currently out of stock.</p>
                    <p class="text-sm text-gray-500 text-center mt-1">Check back later or sign up for notifications.</p>
                </div>
            <?php endif; ?>

            <!-- Product Highlights -->
            <?php if ($product['short_description']): ?>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Highlights</h3>
                    <p class="text-gray-600"><?php echo nl2br(htmlspecialchars($product['short_description'])); ?></p>
                </div>
            <?php endif; ?>

            <!-- Product Details -->
            <div class="border-t pt-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Product Details</h3>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">SKU:</span>
                        <span class="text-gray-900"><?php echo htmlspecialchars($product['sku'] ?? 'N/A'); ?></span>
                    </div>
                    <?php if ($product['weight']): ?>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Weight:</span>
                            <span class="text-gray-900"><?php echo $product['weight']; ?> lbs</span>
                        </div>
                    <?php endif; ?>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Category:</span>
                        <span class="text-gray-900"><?php echo htmlspecialchars($product['category_name'] ?? 'Uncategorized'); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Added:</span>
                        <span class="text-gray-900"><?php echo formatDate($product['created_at']); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Product Description -->
    <?php if ($product['description']): ?>
        <div class="mt-12 bg-white shadow rounded-lg p-6">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Description</h2>
            <div class="prose max-w-none">
                <?php echo nl2br(htmlspecialchars($product['description'])); ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Related Products -->
    <?php if (!empty($relatedProducts)): ?>
        <div class="mt-12">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">You Might Also Like</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php foreach ($relatedProducts as $related): ?>
                    <div class="bg-white shadow rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                        <div class="aspect-w-1 aspect-h-1 bg-gray-200">
                            <?php if ($related['images']): ?>
                                <img src="<?php echo htmlspecialchars($related['images']); ?>" alt="<?php echo htmlspecialchars($related['name']); ?>"
                                     class="w-full h-48 object-cover">
                            <?php else: ?>
                                <div class="w-full h-48 bg-gray-300 flex items-center justify-center">
                                    <svg class="w-12 h-12 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                                <a href="<?php echo BASE_URL; ?>/shop/products/<?php echo $related['slug']; ?>" class="hover:text-indigo-600">
                                    <?php echo htmlspecialchars($related['name']); ?>
                                </a>
                            </h3>
                            <p class="text-gray-600 text-sm mb-2"><?php echo htmlspecialchars($related['category_name'] ?? 'Uncategorized'); ?></p>
                            <div class="flex justify-between items-center">
                                <span class="text-xl font-bold text-gray-900">$<?php echo number_format($related['price'], 2); ?></span>
                                <a href="<?php echo BASE_URL; ?>/shop/products/<?php echo $related['slug']; ?>"
                                   class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm">
                                    View Details
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
function changeImage(imageSrc) {
    document.getElementById('main-image').src = imageSrc;

    // Update thumbnail borders
    const thumbnails = document.querySelectorAll('[onclick^="changeImage"]');
    thumbnails.forEach(thumb => {
        thumb.classList.remove('border-indigo-500');
        thumb.classList.add('border-gray-200');
    });

    event.target.closest('button').classList.remove('border-gray-200');
    event.target.closest('button').classList.add('border-indigo-500');
}

function updateQuantity(change) {
    const quantityInput = document.getElementById('quantity');
    const currentValue = parseInt(quantityInput.value);
    const newValue = Math.max(1, currentValue + change);
    const maxValue = parseInt(quantityInput.max) || 99;

    quantityInput.value = Math.min(newValue, maxValue);
}
</script>
