<?php
/**
 * Setup View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="min-h-screen bg-gray-50 flex items-center justify-center">
    <div class="max-w-md w-full bg-white rounded-lg shadow-lg p-8">
        <div class="text-center">
            <div class="w-16 h-16 bg-indigo-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-cog text-2xl text-indigo-600"></i>
            </div>
            <h1 class="text-2xl font-bold text-gray-900 mb-4">System Setup Required</h1>
            <p class="text-gray-600 mb-8">
                Your salon system needs to be configured before you can start booking appointments.
                Please contact your system administrator to complete the initial setup.
            </p>
            <div class="space-y-4">
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h3 class="text-blue-800 font-medium mb-2">What's needed:</h3>
                    <ul class="text-blue-700 text-sm space-y-1">
                        <li>• Company information setup</li>
                        <li>• Branch locations configuration</li>
                        <li>• Services and pricing setup</li>
                        <li>• Staff accounts creation</li>
                    </ul>
                </div>
                <a href="mailto:admin@salon.com" class="block bg-indigo-600 text-white py-3 px-6 rounded-lg hover:bg-indigo-700 transition-colors">
                    <i class="fas fa-envelope mr-2"></i> Contact Administrator
                </a>
            </div>
        </div>
    </div>
</div>
