<?php
/**
 * Services List View
 * Salon/Spa/Beauty Parlor Booking System
 */

// Get data from controller
$services = $services ?? [];
$categories = $categories ?? [];
$company = $company ?? null;
?>

<!-- Services Page Header -->
<section class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white py-16">
    <div class="container mx-auto px-4">
        <div class="text-center">
            <h1 class="text-4xl md:text-5xl font-bold mb-4">Our Services</h1>
            <p class="text-xl text-indigo-100 max-w-2xl mx-auto">
                Discover our comprehensive range of professional beauty and wellness services
                designed to enhance your natural beauty and leave you feeling rejuvenated.
            </p>
        </div>
    </div>
</section>

<!-- Category Filter -->
<section class="py-8 bg-white border-b">
    <div class="container mx-auto px-4">
        <div class="flex flex-wrap justify-center gap-4">
            <button class="category-filter px-6 py-3 rounded-full font-medium transition-all duration-200 <?php echo !isset($_GET['category']) ? 'bg-indigo-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>" data-category="">
                All Services
            </button>
            <?php foreach ($categories as $category): ?>
                <button class="category-filter px-6 py-3 rounded-full font-medium transition-all duration-200 <?php echo (isset($_GET['category']) && $_GET['category'] == $category['slug']) ? 'bg-indigo-600 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>" data-category="<?php echo htmlspecialchars($category['slug']); ?>">
                    <?php echo htmlspecialchars($category['name']); ?>
                </button>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Services Grid -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <?php if (empty($services)): ?>
            <div class="text-center py-16">
                <div class="w-24 h-24 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-concierge-bell text-3xl text-gray-400"></i>
                </div>
                <h3 class="text-2xl font-semibold text-gray-900 mb-2">No Services Available</h3>
                <p class="text-gray-600 mb-6">We're currently updating our services. Please check back soon!</p>
                <a href="<?php echo BASE_URL; ?>/" class="bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors">
                    Back to Home
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8" id="services-grid">
                <?php foreach ($services as $service): ?>
                    <div class="service-card bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                        <div class="relative">
                            <img src="<?php echo htmlspecialchars($service['image'] ?? BASE_URL . '/assets/images/placeholder.jpg'); ?>"
                                 alt="<?php echo htmlspecialchars($service['name']); ?>"
                                 class="w-full h-64 object-cover" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                            <div class="absolute bottom-4 left-4 right-4">
                                <h3 class="text-white text-xl font-bold mb-1"><?php echo htmlspecialchars($service['name']); ?></h3>
                                <?php if (!empty($service['short_description'])): ?>
                                    <p class="text-white/80 text-sm"><?php echo htmlspecialchars($service['short_description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="p-6">
                            <div class="flex justify-between items-center mb-4">
                                <span class="text-3xl font-bold text-indigo-600">
                                    <?php echo htmlspecialchars($company['currency'] ?? '$') . number_format($service['price'], 2); ?>
                                </span>
                                <span class="text-gray-500 text-sm">
                                    <?php echo htmlspecialchars($service['duration_minutes']); ?> min
                                </span>
                            </div>
                            <?php if (!empty($service['description'])): ?>
                                <p class="text-gray-600 mb-4 line-clamp-3"><?php echo htmlspecialchars(substr($service['description'], 0, 150)); ?>...</p>
                            <?php endif; ?>
                            <div class="flex gap-2">
                                <a href="<?php echo BASE_URL; ?>/services/<?php echo htmlspecialchars($service['slug']); ?>"
                                   class="flex-1 bg-indigo-600 text-white text-center py-3 rounded-lg hover:bg-indigo-700 transition-colors font-medium">
                                    View Details
                                </a>
                                <a href="<?php echo BASE_URL; ?>/book?service=<?php echo htmlspecialchars($service['slug']); ?>"
                                   class="bg-pink-600 text-white px-6 py-3 rounded-lg hover:bg-pink-700 transition-colors font-medium">
                                    <i class="fas fa-calendar-check"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-gradient-to-r from-indigo-900 to-purple-900 text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">Ready to Book Your Service?</h2>
        <p class="text-xl text-indigo-200 mb-8 max-w-2xl mx-auto">
            Experience the luxury and professionalism you deserve. Our expert stylists are ready to make you look and feel amazing.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="<?php echo BASE_URL; ?>/book" class="bg-gradient-to-r from-pink-500 to-purple-600 text-white px-8 py-4 rounded-full text-lg font-semibold hover:from-pink-600 hover:to-purple-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                <i class="fas fa-calendar-check mr-2"></i>
                Book Appointment
            </a>
            <a href="tel:+<?php echo htmlspecialchars($company['phone'] ?? '15550123456'); ?>" class="bg-white text-gray-900 px-8 py-4 rounded-full text-lg font-semibold hover:bg-gray-100 transform hover:scale-105 transition-all duration-200 shadow-lg">
                <i class="fas fa-phone mr-2"></i>
                Call Now
            </a>
        </div>
    </div>
</section>

<script>
// Category filtering
document.addEventListener('DOMContentLoaded', function() {
    const categoryButtons = document.querySelectorAll('.category-filter');
    const serviceCards = document.querySelectorAll('.service-card');

    categoryButtons.forEach(button => {
        button.addEventListener('click', function() {
            const category = this.dataset.category;

            // Update button states
            categoryButtons.forEach(btn => {
                btn.classList.remove('bg-indigo-600', 'text-white');
                btn.classList.add('bg-gray-100', 'text-gray-700', 'hover:bg-gray-200');
            });
            this.classList.remove('bg-gray-100', 'text-gray-700', 'hover:bg-gray-200');
            this.classList.add('bg-indigo-600', 'text-white');

            // Filter services (this would be implemented with AJAX in a real app)
            if (category) {
                window.location.href = `<?php echo BASE_URL; ?>/services?category=${category}`;
            } else {
                window.location.href = '<?php echo BASE_URL; ?>/services';
            }
        });
    });
});
</script>
