<?php
/**
 * Admin Layout Template
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo htmlspecialchars($metaDescription ?? 'Luxury Beauty Spa Management System'); ?>">
    <meta name="keywords" content="salon, spa, beauty, management, booking, administration">
    <title><?php echo htmlspecialchars($pageTitle ?? 'Admin Dashboard'); ?> - Luxury Beauty Spa</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo BASE_URL; ?>/assets/images/favicon.ico">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <link href="<?php echo BASE_URL; ?>/assets/css/admin.css" rel="stylesheet">

    <!-- Additional CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 font-sans">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="w-64 bg-gray-800 shadow-lg">
            <div class="flex flex-col h-full">
                <!-- Logo -->
                <div class="flex items-center justify-center h-16 bg-gray-900">
                    <span class="text-white text-xl font-bold">Admin Panel</span>
                </div>

                <!-- Navigation -->
                <nav class="flex-1 px-4 py-6 space-y-2">
                    <a href="<?php echo BASE_URL; ?>/admin" class="nav-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>">
                        <i class="fas fa-tachometer-alt mr-3"></i>
                        Dashboard
                    </a>

                    <div class="border-t border-gray-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/admin/bookings" class="nav-link <?php echo $currentPage === 'bookings' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-check mr-3"></i>
                        Bookings
                    </a>

                    <a href="<?php echo BASE_URL; ?>/admin/services" class="nav-link <?php echo $currentPage === 'services' ? 'active' : ''; ?>">
                        <i class="fas fa-concierge-bell mr-3"></i>
                        Services
                    </a>

                    <a href="<?php echo BASE_URL; ?>/admin/staff" class="nav-link <?php echo $currentPage === 'staff' ? 'active' : ''; ?>">
                        <i class="fas fa-users mr-3"></i>
                        Staff
                    </a>

                    <a href="<?php echo BASE_URL; ?>/admin/customers" class="nav-link <?php echo $currentPage === 'customers' ? 'active' : ''; ?>">
                        <i class="fas fa-user-friends mr-3"></i>
                        Customers
                    </a>

                    <div class="border-t border-gray-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/admin/reports" class="nav-link <?php echo $currentPage === 'reports' ? 'active' : ''; ?>">
                        <i class="fas fa-chart-bar mr-3"></i>
                        Reports
                    </a>

                    <a href="<?php echo BASE_URL; ?>/admin/settings" class="nav-link <?php echo $currentPage === 'settings' ? 'active' : ''; ?>">
                        <i class="fas fa-cog mr-3"></i>
                        Settings
                    </a>

                    <div class="border-t border-gray-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/logout" class="nav-link text-red-400 hover:text-red-300">
                        <i class="fas fa-sign-out-alt mr-3"></i>
                        Logout
                    </a>
                </nav>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Bar -->
            <header class="bg-white shadow-sm border-b border-gray-200">
                <div class="px-6 py-4 flex justify-between items-center">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()" class="text-gray-500 hover:text-gray-700 md:hidden">
                            <i class="fas fa-bars"></i>
                        </button>
                        <h1 class="ml-4 text-2xl font-semibold text-gray-900"><?php echo htmlspecialchars($pageTitle ?? 'Dashboard'); ?></h1>
                    </div>

                    <div class="flex items-center space-x-4">
                        <!-- Notifications -->
                        <button class="text-gray-500 hover:text-gray-700 relative">
                            <i class="fas fa-bell"></i>
                            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">3</span>
                        </button>

                        <!-- User Menu -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="flex items-center space-x-2 text-gray-700 hover:text-gray-900">
                                <div class="w-8 h-8 bg-indigo-500 rounded-full flex items-center justify-center">
                                    <span class="text-white text-sm font-medium">
                                        <?php echo strtoupper(substr($this->auth->firstName(), 0, 1) . substr($this->auth->lastName(), 0, 1)); ?>
                                    </span>
                                </div>
                                <span class="hidden md:block"><?php echo htmlspecialchars($this->auth->firstName()); ?></span>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </button>

                            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg z-50">
                                <div class="py-1">
                                    <a href="<?php echo BASE_URL; ?>/admin/profile" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-user mr-2"></i>My Profile
                                    </a>
                                    <a href="<?php echo BASE_URL; ?>/admin/settings" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-cog mr-2"></i>Settings
                                    </a>
                                    <div class="border-t border-gray-100"></div>
                                    <a href="<?php echo BASE_URL; ?>/logout" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                                        <i class="fas fa-sign-out-alt mr-2"></i>Logout
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto bg-gray-100 p-6">
                <?php echo $content; ?>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.w-64');
            sidebar.classList.toggle('hidden');
        }
    </script>

    <!-- Custom JavaScript -->
    <script src="<?php echo BASE_URL; ?>/assets/js/admin.js"></script>
</body>
</html>
