<?php
/**
 * 500 Internal Server Error Page
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="min-h-screen bg-gray-50 flex flex-col justify-center py-12 sm:px-6 lg:px-8">
    <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
        <div class="bg-white py-8 px-4 shadow-xl rounded-lg sm:px-10 text-center">
            <!-- Error Icon -->
            <div class="mx-auto flex items-center justify-center h-24 w-24 rounded-full bg-red-100 mb-6">
                <svg class="h-12 w-12 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>

            <!-- Error Message -->
            <h1 class="text-4xl font-bold text-gray-900 mb-2">500</h1>
            <h2 class="text-2xl font-semibold text-gray-700 mb-4">Internal Server Error</h2>
            <p class="text-gray-600 mb-8">
                We're experiencing some technical difficulties. Our team has been notified and is working to fix the issue.
            </p>

            <!-- Actions -->
            <div class="space-y-4">
                <button onclick="location.reload()" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-redo mr-2"></i>
                    Try Again
                </button>

                <a href="<?php echo BASE_URL; ?>" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-home mr-2"></i>
                    Go to Homepage
                </a>

                <a href="<?php echo BASE_URL; ?>/contact" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-envelope mr-2"></i>
                    Contact Support
                </a>
            </div>

            <!-- Error Details -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <details class="text-left">
                    <summary class="cursor-pointer text-sm font-medium text-gray-700 hover:text-gray-900">
                        Technical Details
                    </summary>
                    <div class="mt-4 p-4 bg-gray-50 rounded-md">
                        <div class="text-xs text-gray-600 space-y-2">
                            <div><strong>Timestamp:</strong> <?php echo date('Y-m-d H:i:s T'); ?></div>
                            <div><strong>Page:</strong> <?php echo htmlspecialchars($_SERVER['REQUEST_URI'] ?? 'Unknown'); ?></div>
                            <div><strong>User Agent:</strong> <?php echo htmlspecialchars($_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'); ?></div>
                            <div><strong>IP Address:</strong> <?php echo htmlspecialchars($_SERVER['REMOTE_ADDR'] ?? 'Unknown'); ?></div>
                        </div>
                        <div class="mt-4 text-xs text-gray-500">
                            This information helps our technical team identify and resolve the issue faster.
                        </div>
                    </div>
                </details>
            </div>

            <!-- Status Updates -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 mb-4">System Status</h3>
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Website</span>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                            Degraded
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Booking System</span>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                            Checking...
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Support</span>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                            Available
                        </span>
                    </div>
                </div>
                <p class="text-xs text-gray-500 mt-3">
                    Status updates are refreshed every few minutes.
                </p>
            </div>

            <!-- Alternative Contact -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Alternative Contact</h3>
                <div class="space-y-3 text-sm text-gray-600">
                    <div class="flex items-center">
                        <i class="fas fa-phone mr-3 text-indigo-600"></i>
                        <a href="tel:+15550123" class="text-indigo-600 hover:text-indigo-800">
                            Call us: +1 (555) 012-3456
                        </a>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-envelope mr-3 text-indigo-600"></i>
                        <a href="mailto:support@luxurybeautyspa.com" class="text-indigo-600 hover:text-indigo-800">
                            Email: support@luxurybeautyspa.com
                        </a>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-clock mr-3 text-indigo-600"></i>
                        <span>Support hours: Mon-Fri 9AM-6PM</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Message -->
        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600">
                We apologize for the inconvenience. Our team is working to restore service as quickly as possible.
            </p>
        </div>
    </div>
</div>
