<?php
/**
 * 403 Forbidden Error Page
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="min-h-screen bg-gray-50 flex flex-col justify-center py-12 sm:px-6 lg:px-8">
    <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
        <div class="bg-white py-8 px-4 shadow-xl rounded-lg sm:px-10 text-center">
            <!-- Error Icon -->
            <div class="mx-auto flex items-center justify-center h-24 w-24 rounded-full bg-orange-100 mb-6">
                <svg class="h-12 w-12 text-orange-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m0 0v2m0-2h2m-2 0H8m13 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>

            <!-- Error Message -->
            <h1 class="text-4xl font-bold text-gray-900 mb-2">403</h1>
            <h2 class="text-2xl font-semibold text-gray-700 mb-4">Access Forbidden</h2>
            <p class="text-gray-600 mb-8">
                You don't have permission to access this page. This might be because you need to log in or you don't have the required permissions.
            </p>

            <!-- Actions -->
            <div class="space-y-4">
                <?php if (!$this->auth->check()): ?>
                    <a href="<?php echo BASE_URL; ?>/login" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        Login to Continue
                    </a>
                <?php else: ?>
                    <a href="<?php echo BASE_URL; ?>" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <i class="fas fa-home mr-2"></i>
                        Go to Dashboard
                    </a>
                <?php endif; ?>

                <button onclick="history.back()" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Go Back
                </button>

                <a href="<?php echo BASE_URL; ?>/contact" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-envelope mr-2"></i>
                    Contact Support
                </a>
            </div>

            <!-- User Info -->
            <?php if ($this->auth->check()): ?>
                <div class="mt-8 pt-6 border-t border-gray-200">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <h3 class="text-sm font-medium text-gray-900 mb-2">Your Account</h3>
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-indigo-500 rounded-full flex items-center justify-center">
                                    <span class="text-white text-sm font-medium">
                                        <?php echo strtoupper(substr($this->auth->firstName(), 0, 1) . substr($this->auth->lastName(), 0, 1)); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900">
                                    <?php echo htmlspecialchars($this->auth->firstName() . ' ' . $this->auth->lastName()); ?>
                                </p>
                                <p class="text-xs text-gray-600"><?php echo ucfirst($this->auth->role()); ?> Account</p>
                            </div>
                        </div>

                        <div class="mt-3 text-xs text-gray-600">
                            <p>If you believe you should have access to this page, please contact your administrator or our support team.</p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Help Links -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <p class="text-sm text-gray-600 mb-4">You might be looking for:</p>
                <div class="grid grid-cols-1 gap-2 text-sm">
                    <a href="<?php echo BASE_URL; ?>/services" class="text-indigo-600 hover:text-indigo-800">Browse Services</a>
                    <a href="<?php echo BASE_URL; ?>/book" class="text-indigo-600 hover:text-indigo-800">Book an Appointment</a>
                    <a href="<?php echo BASE_URL; ?>/profile" class="text-indigo-600 hover:text-indigo-800">My Profile</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-indigo-600 hover:text-indigo-800">Contact Support</a>
                </div>
            </div>
        </div>

        <!-- Additional Help -->
        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600">
                Need help? <a href="<?php echo BASE_URL; ?>/contact" class="text-indigo-600 hover:text-indigo-800">Contact our support team</a>.
            </p>
        </div>
    </div>
</div>