<?php
/**
 * Booking Details View
 * Salon/Spa/Beauty Parlor Booking System
 */

// Get data from controller
$booking = $booking ?? null;
$company = $this->db->query("SELECT * FROM companies WHERE id = ?", [$booking['company_id']])->single();
?>

<div class="min-h-screen bg-gray-50">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <a href="<?php echo BASE_URL; ?>/" class="text-gray-600 hover:text-gray-900">
                        <i class="fas fa-arrow-left text-xl"></i>
                    </a>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900">Booking Details</h1>
                        <p class="text-gray-600"><?php echo htmlspecialchars($booking['booking_number']); ?></p>
                    </div>
                </div>
                <div class="flex space-x-2">
                    <?php if ($booking['status'] === 'pending'): ?>
                        <button class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition-colors text-sm">
                            <i class="fas fa-check mr-1"></i> Confirm
                        </button>
                        <button class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition-colors text-sm">
                            <i class="fas fa-times mr-1"></i> Cancel
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-4xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Booking Details -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Status Card -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h2 class="text-xl font-semibold text-gray-900">Booking Status</h2>
                            <span class="status-badge px-3 py-1 rounded-full text-sm font-medium <?php
                                switch ($booking['status']) {
                                    case 'confirmed':
                                        echo 'bg-green-100 text-green-800';
                                        break;
                                    case 'pending':
                                        echo 'bg-yellow-100 text-yellow-800';
                                        break;
                                    case 'completed':
                                        echo 'bg-blue-100 text-blue-800';
                                        break;
                                    case 'cancelled':
                                        echo 'bg-red-100 text-red-800';
                                        break;
                                    case 'no_show':
                                        echo 'bg-gray-100 text-gray-800';
                                        break;
                                    default:
                                        echo 'bg-gray-100 text-gray-800';
                                }
                            ?>">
                                <?php echo ucfirst($booking['status']); ?>
                            </span>
                        </div>

                        <?php if ($booking['status'] === 'cancelled' && $booking['cancellation_reason']): ?>
                            <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                                <h3 class="text-red-800 font-medium">Cancellation Reason</h3>
                                <p class="text-red-700"><?php echo htmlspecialchars($booking['cancellation_reason']); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Service Details -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h2 class="text-xl font-semibold text-gray-900 mb-4">Service Details</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <h3 class="font-medium text-gray-900 mb-2"><?php echo htmlspecialchars($booking['service_name']); ?></h3>
                                <p class="text-gray-600 text-sm mb-4"><?php echo htmlspecialchars($booking['duration_minutes']); ?> minutes</p>
                                <div class="flex items-center space-x-4 text-sm text-gray-600">
                                    <span><i class="fas fa-calendar mr-1"></i> <?php echo date('M j, Y', strtotime($booking['start_at'])); ?></span>
                                    <span><i class="fas fa-clock mr-1"></i> <?php echo date('g:i A', strtotime($booking['start_at'])); ?></span>
                                </div>
                            </div>
                            <div>
                                <div class="text-right">
                                    <p class="text-2xl font-bold text-gray-900"><?php echo htmlspecialchars($company['currency'] ?? '$') . number_format($booking['total_amount'], 2); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Location -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h2 class="text-xl font-semibold text-gray-900 mb-4">Location</h2>
                        <div class="flex items-start space-x-4">
                            <div class="flex-shrink-0">
                                <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-map-marker-alt text-indigo-600"></i>
                                </div>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-900"><?php echo htmlspecialchars($booking['branch_name']); ?></h3>
                                <p class="text-gray-600"><?php echo htmlspecialchars($booking['address']); ?></p>
                                <a href="https://maps.google.com/?q=<?php echo urlencode($booking['address']); ?>"
                                   target="_blank"
                                   class="text-indigo-600 hover:text-indigo-800 text-sm mt-2 inline-block">
                                    <i class="fas fa-external-link-alt mr-1"></i> View on Map
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Staff -->
                    <?php if ($booking['staff_first_name']): ?>
                        <div class="bg-white rounded-lg shadow-sm p-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-4">Your Stylist</h2>
                            <div class="flex items-center space-x-4">
                                <div class="w-16 h-16 bg-gray-200 rounded-full flex items-center justify-center">
                                    <span class="text-gray-600 font-medium text-lg">
                                        <?php echo substr($booking['staff_first_name'], 0, 1) . substr($booking['staff_last_name'], 0, 1); ?>
                                    </span>
                                </div>
                                <div>
                                    <h3 class="font-medium text-gray-900">
                                        <?php echo htmlspecialchars($booking['staff_first_name'] . ' ' . $booking['staff_last_name']); ?>
                                    </h3>
                                    <p class="text-gray-600">Professional Stylist</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Notes -->
                    <?php if ($booking['notes']): ?>
                        <div class="bg-white rounded-lg shadow-sm p-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-4">Special Requests</h2>
                            <p class="text-gray-700"><?php echo nl2br(htmlspecialchars($booking['notes'])); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Customer Info -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h2 class="text-xl font-semibold text-gray-900 mb-4">Customer Information</h2>
                        <div class="space-y-3">
                            <div>
                                <label class="text-sm font-medium text-gray-500">Name</label>
                                <p class="text-gray-900">
                                    <?php echo htmlspecialchars(($booking['guest_first_name'] ?? '') . ' ' . ($booking['guest_last_name'] ?? '')); ?>
                                </p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Email</label>
                                <p class="text-gray-900"><?php echo htmlspecialchars($booking['guest_email'] ?? ''); ?></p>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Phone</label>
                                <p class="text-gray-900"><?php echo htmlspecialchars($booking['guest_phone'] ?? ''); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h2 class="text-xl font-semibold text-gray-900 mb-4">Actions</h2>
                        <div class="space-y-3">
                            <a href="tel:<?php echo htmlspecialchars($company['phone'] ?? ''); ?>"
                               class="w-full bg-indigo-600 text-white py-3 px-4 rounded-lg hover:bg-indigo-700 transition-colors text-center block">
                                <i class="fas fa-phone mr-2"></i> Call Us
                            </a>

                            <?php if ($booking['status'] === 'confirmed'): ?>
                                <button class="w-full bg-gray-600 text-white py-3 px-4 rounded-lg hover:bg-gray-700 transition-colors">
                                    <i class="fas fa-calendar-times mr-2"></i> Reschedule
                                </button>
                            <?php endif; ?>

                            <a href="<?php echo BASE_URL; ?>/bookings/<?php echo $booking['id']; ?>/receipt"
                               class="w-full bg-green-600 text-white py-3 px-4 rounded-lg hover:bg-green-700 transition-colors text-center block">
                                <i class="fas fa-download mr-2"></i> Download Receipt
                            </a>
                        </div>
                    </div>

                    <!-- Support -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h2 class="text-xl font-semibold text-gray-900 mb-4">Need Help?</h2>
                        <p class="text-gray-600 text-sm mb-4">
                            Have questions about your booking? We're here to help.
                        </p>
                        <a href="<?php echo BASE_URL; ?>/contact"
                           class="text-indigo-600 hover:text-indigo-800 text-sm font-medium">
                            <i class="fas fa-envelope mr-1"></i> Contact Support
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
