<?php
/**
 * Booking Wizard View
 * Salon/Spa/Beauty Parlor Booking System
 */

// Get data from controller
$branches = $branches ?? [];
$services = $services ?? [];
$company = $company ?? null;
$selectedService = $selectedService ?? null;
$selectedBranch = $selectedBranch ?? null;
?>

<div class="min-h-screen bg-gray-50">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <a href="<?php echo BASE_URL; ?>/" class="text-gray-600 hover:text-gray-900">
                        <i class="fas fa-arrow-left text-xl"></i>
                    </a>
                    <h1 class="text-2xl font-bold text-gray-900">Book Appointment</h1>
                </div>
                <div class="text-sm text-gray-500">
                    Step <span id="current-step">1</span> of 5
                </div>
            </div>
        </div>
    </div>

    <!-- Progress Bar -->
    <div class="bg-white border-b">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center space-x-2">
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-indigo-600 text-white rounded-full flex items-center justify-center text-sm font-medium" id="step-1-indicator">1</div>
                        <div class="flex-1 h-1 bg-gray-200 mx-2">
                            <div class="h-1 bg-indigo-600 transition-all duration-300" id="progress-1" style="width: 100%"></div>
                        </div>
                    </div>
                </div>
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center text-sm font-medium" id="step-2-indicator">2</div>
                        <div class="flex-1 h-1 bg-gray-200 mx-2">
                            <div class="h-1 bg-indigo-600 transition-all duration-300" id="progress-2" style="width: 0%"></div>
                        </div>
                    </div>
                </div>
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center text-sm font-medium" id="step-3-indicator">3</div>
                        <div class="flex-1 h-1 bg-gray-200 mx-2">
                            <div class="h-1 bg-indigo-600 transition-all duration-300" id="progress-3" style="width: 0%"></div>
                        </div>
                    </div>
                </div>
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center text-sm font-medium" id="step-4-indicator">4</div>
                        <div class="flex-1 h-1 bg-gray-200 mx-2">
                            <div class="h-1 bg-indigo-600 transition-all duration-300" id="progress-4" style="width: 0%"></div>
                        </div>
                    </div>
                </div>
                <div class="w-8 h-8 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center text-sm font-medium" id="step-5-indicator">5</div>
            </div>
            <div class="flex justify-between mt-2 text-xs text-gray-500">
                <span>Branch</span>
                <span>Service</span>
                <span>Date & Time</span>
                <span>Staff</span>
                <span>Details</span>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-8">
        <form id="booking-form" method="POST" action="<?php echo BASE_URL; ?>/book">
            <?php echo csrf_field(); ?>

            <!-- Step 1: Select Branch -->
            <div id="step-1" class="step-content">
                <div class="max-w-2xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Select Your Branch</h2>
                    <div class="grid gap-4">
                        <?php foreach ($branches as $branch): ?>
                            <label class="branch-option block bg-white rounded-lg shadow-sm border-2 border-gray-200 p-4 cursor-pointer hover:border-indigo-300 hover:shadow-md transition-all">
                                <input type="radio" name="branch_id" value="<?php echo $branch['id']; ?>" class="hidden" required>
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="font-semibold text-gray-900"><?php echo htmlspecialchars($branch['name']); ?></h3>
                                        <p class="text-gray-600 text-sm"><?php echo htmlspecialchars($branch['address']); ?></p>
                                        <?php if ($branch['phone']): ?>
                                            <p class="text-gray-500 text-sm"><?php echo htmlspecialchars($branch['phone']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-right">
                                        <?php if ($branch['is_main_branch']): ?>
                                            <span class="inline-block bg-indigo-100 text-indigo-800 text-xs px-2 py-1 rounded-full">Main Branch</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </label>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="button" class="next-step bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors font-medium">
                            Next: Select Service
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 2: Select Service -->
            <div id="step-2" class="step-content hidden">
                <div class="max-w-4xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Choose Your Service</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php foreach ($services as $service): ?>
                            <label class="service-option block bg-white rounded-lg shadow-sm border-2 border-gray-200 p-6 cursor-pointer hover:border-indigo-300 hover:shadow-md transition-all">
                                <input type="radio" name="service_id" value="<?php echo $service['id']; ?>" class="hidden" required>
                                <div class="text-center">
                                    <img src="<?php echo htmlspecialchars($service['image'] ?? BASE_URL . '/assets/images/placeholder.jpg'); ?>"
                                         alt="<?php echo htmlspecialchars($service['name']); ?>"
                                         class="w-full h-32 object-cover rounded-lg mb-4" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                                    <h3 class="font-semibold text-gray-900 mb-2"><?php echo htmlspecialchars($service['name']); ?></h3>
                                    <p class="text-2xl font-bold text-indigo-600 mb-2">
                                        <?php echo htmlspecialchars($company['currency'] ?? '$') . number_format($service['price'], 2); ?>
                                    </p>
                                    <p class="text-gray-600 text-sm"><?php echo htmlspecialchars($service['duration_minutes']); ?> minutes</p>
                                </div>
                            </label>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="button" class="prev-step bg-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-400 transition-colors mr-4">
                            Previous
                        </button>
                        <button type="button" class="next-step bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors">
                            Next: Select Date & Time
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 3: Select Date & Time -->
            <div id="step-3" class="step-content hidden">
                <div class="max-w-2xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Select Date & Time</h2>

                    <!-- Date Selection -->
                    <div class="mb-8">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Preferred Date</label>
                        <input type="date" id="booking-date" name="booking_date" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required min="<?php echo date('Y-m-d'); ?>">
                    </div>

                    <!-- Time Slots -->
                    <div id="time-slots" class="mb-8">
                        <label class="block text-sm font-medium text-gray-700 mb-4">Available Times</label>
                        <div class="grid grid-cols-3 md:grid-cols-4 gap-3" id="time-slots-grid">
                            <!-- Time slots will be loaded via JavaScript -->
                        </div>
                        <input type="hidden" name="start_time" id="selected-time" required>
                    </div>

                    <div class="text-center">
                        <button type="button" class="prev-step bg-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-400 transition-colors mr-4">
                            Previous
                        </button>
                        <button type="button" class="next-step bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors">
                            Next: Select Staff
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 4: Select Staff -->
            <div id="step-4" class="step-content hidden">
                <div class="max-w-4xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Choose Your Stylist</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6" id="staff-options">
                        <!-- Staff options will be loaded via JavaScript -->
                    </div>
                    <div class="mt-8 text-center">
                        <button type="button" class="prev-step bg-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-400 transition-colors mr-4">
                            Previous
                        </button>
                        <button type="button" class="next-step bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors">
                            Next: Your Details
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 5: Customer Details -->
            <div id="step-5" class="step-content hidden">
                <div class="max-w-2xl mx-auto">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Your Information</h2>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">First Name *</label>
                            <input type="text" name="first_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Last Name *</label>
                            <input type="text" name="last_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required>
                        </div>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email Address *</label>
                        <input type="email" name="email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Phone Number *</label>
                        <input type="tel" name="phone" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Special Requests or Notes</label>
                        <textarea name="notes" rows="4" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" placeholder="Any special requests or additional information..."></textarea>
                    </div>

                    <div class="mt-8 text-center">
                        <button type="button" class="prev-step bg-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-400 transition-colors mr-4">
                            Previous
                        </button>
                        <button type="submit" class="bg-indigo-600 text-white px-8 py-3 rounded-lg hover:bg-indigo-700 transition-colors font-medium">
                            <i class="fas fa-calendar-check mr-2"></i>
                            Confirm Booking
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Booking Wizard JavaScript
document.addEventListener('DOMContentLoaded', function() {
    let currentStep = 1;
    const totalSteps = 5;
    let selectedBranchId = null;
    let selectedServiceId = null;
    let selectedStaffId = null;
    let selectedDate = null;
    let selectedTime = null;

    // Step navigation
    function showStep(step) {
        // Hide all steps
        document.querySelectorAll('.step-content').forEach(el => el.classList.add('hidden'));

        // Show current step
        document.getElementById(`step-${step}`).classList.remove('hidden');

        // Update progress indicators
        for (let i = 1; i <= totalSteps; i++) {
            const indicator = document.getElementById(`step-${i}-indicator`);
            const progress = document.getElementById(`progress-${i}`);

            if (i < step) {
                indicator.classList.remove('bg-gray-300', 'text-gray-600');
                indicator.classList.add('bg-indigo-600', 'text-white');
                if (progress) progress.style.width = '100%';
            } else if (i === step) {
                indicator.classList.remove('bg-gray-300', 'text-gray-600');
                indicator.classList.add('bg-indigo-600', 'text-white');
                if (progress) progress.style.width = '100%';
            } else {
                indicator.classList.remove('bg-indigo-600', 'text-white');
                indicator.classList.add('bg-gray-300', 'text-gray-600');
                if (progress) progress.style.width = '0%';
            }
        }

        document.getElementById('current-step').textContent = step;
        currentStep = step;
    }

    // Next step buttons
    document.querySelectorAll('.next-step').forEach(button => {
        button.addEventListener('click', function() {
            if (currentStep < totalSteps) {
                if (validateCurrentStep()) {
                    showStep(currentStep + 1);
                }
            }
        });
    });

    // Previous step buttons
    document.querySelectorAll('.prev-step').forEach(button => {
        button.addEventListener('click', function() {
            if (currentStep > 1) {
                showStep(currentStep - 1);
            }
        });
    });

    // Branch selection
    document.querySelectorAll('.branch-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.branch-option').forEach(opt => {
                opt.classList.remove('border-indigo-500', 'ring-2', 'ring-indigo-200');
                opt.classList.add('border-gray-200');
            });
            this.classList.remove('border-gray-200');
            this.classList.add('border-indigo-500', 'ring-2', 'ring-indigo-200');
            selectedBranchId = this.querySelector('input[type="radio"]').value;
        });
    });

    // Service selection
    document.querySelectorAll('.service-option').forEach(option => {
        option.addEventListener('click', function() {
            document.querySelectorAll('.service-option').forEach(opt => {
                opt.classList.remove('border-indigo-500', 'ring-2', 'ring-indigo-200');
                opt.classList.add('border-gray-200');
            });
            this.classList.remove('border-gray-200');
            this.classList.add('border-indigo-500', 'ring-2', 'ring-indigo-200');
            selectedServiceId = this.querySelector('input[type="radio"]').value;
        });
    });

    // Date change handler
    document.getElementById('booking-date').addEventListener('change', function() {
        selectedDate = this.value;
        loadTimeSlots();
    });

    // Time slot selection
    function loadTimeSlots() {
        if (!selectedDate || !selectedBranchId || !selectedServiceId) return;

        const timeSlotsGrid = document.getElementById('time-slots-grid');
        timeSlotsGrid.innerHTML = '<div class="col-span-full text-center py-8"><div class="animate-spin rounded-full h-8 w-8 border-b-2 border-indigo-600 mx-auto"></div><p class="mt-2 text-gray-600">Loading available times...</p></div>';

        // Mock time slots for demo (in real app, this would be an AJAX call)
        setTimeout(() => {
            const timeSlots = ['09:00', '10:00', '11:00', '14:00', '15:00', '16:00'];
            timeSlotsGrid.innerHTML = '';

            timeSlots.forEach(time => {
                const slotDiv = document.createElement('div');
                slotDiv.className = 'time-slot bg-white border border-gray-300 rounded-lg p-3 text-center cursor-pointer hover:border-indigo-500 hover:bg-indigo-50 transition-colors';
                slotDiv.textContent = time;
                slotDiv.addEventListener('click', function() {
                    document.querySelectorAll('.time-slot').forEach(slot => {
                        slot.classList.remove('border-indigo-500', 'bg-indigo-50', 'ring-2', 'ring-indigo-200');
                    });
                    this.classList.add('border-indigo-500', 'bg-indigo-50', 'ring-2', 'ring-indigo-200');
                    document.getElementById('selected-time').value = time;
                    selectedTime = time;
                });
                timeSlotsGrid.appendChild(slotDiv);
            });
        }, 1000);
    }

    // Staff selection (loaded when moving to step 4)
    function loadStaffOptions() {
        const staffContainer = document.getElementById('staff-options');
        staffContainer.innerHTML = '<div class="col-span-full text-center py-8"><div class="animate-spin rounded-full h-8 w-8 border-b-2 border-indigo-600 mx-auto"></div><p class="mt-2 text-gray-600">Loading staff...</p></div>';

        // Mock staff for demo
        setTimeout(() => {
            const staff = [
                { id: 1, name: 'Sarah Johnson', specialty: 'Hair Styling', image: '/assets/images/staff/sarah.jpg' },
                { id: 2, name: 'Mike Chen', specialty: 'Massage Therapy', image: '/assets/images/staff/mike.jpg' },
                { id: 3, name: 'Emma Davis', specialty: 'Facial Treatments', image: '/assets/images/staff/emma.jpg' }
            ];

            staffContainer.innerHTML = '';

            staff.forEach(person => {
                const staffDiv = document.createElement('label');
                staffDiv.className = 'staff-option block bg-white rounded-lg shadow-sm border-2 border-gray-200 p-6 cursor-pointer hover:border-indigo-300 hover:shadow-md transition-all';
                staffDiv.innerHTML = `
                    <input type="radio" name="staff_id" value="${person.id}" class="hidden">
                    <div class="text-center">
                        <img src="${person.image}" alt="${person.name}" class="w-20 h-20 rounded-full mx-auto mb-4 object-cover" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                        <h3 class="font-semibold text-gray-900 mb-1">${person.name}</h3>
                        <p class="text-gray-600 text-sm">${person.specialty}</p>
                    </div>
                `;
                staffDiv.addEventListener('click', function() {
                    document.querySelectorAll('.staff-option').forEach(opt => {
                        opt.classList.remove('border-indigo-500', 'ring-2', 'ring-indigo-200');
                        opt.classList.add('border-gray-200');
                    });
                    this.classList.remove('border-gray-200');
                    this.classList.add('border-indigo-500', 'ring-2', 'ring-indigo-200');
                    selectedStaffId = person.id;
                });
                staffContainer.appendChild(staffDiv);
            });
        }, 1000);
    }

    // Step validation
    function validateCurrentStep() {
        switch (currentStep) {
            case 1:
                if (!selectedBranchId) {
                    alert('Please select a branch');
                    return false;
                }
                break;
            case 2:
                if (!selectedServiceId) {
                    alert('Please select a service');
                    return false;
                }
                break;
            case 3:
                if (!selectedDate || !selectedTime) {
                    alert('Please select a date and time');
                    return false;
                }
                break;
            case 4:
                // Staff selection is optional
                break;
        }
        return true;
    }

    // When moving to step 4, load staff
    document.querySelector('#step-3 .next-step').addEventListener('click', function() {
        setTimeout(() => {
            if (currentStep === 4) {
                loadStaffOptions();
            }
        }, 100);
    });

    // Set minimum date to today
    const today = new Date().toISOString().split('T')[0];
    document.getElementById('booking-date').setAttribute('min', today);
});
</script>
