<?php
/**
 * Admin Service Edit View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Edit Service</h1>
        <a href="<?php echo BASE_URL; ?>/admin/services" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Services
        </a>
    </div>

    <?php if (isset($_SESSION['form_errors'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul>
                <?php foreach ($_SESSION['form_errors'] as $error): ?>
                    <li><?php echo htmlspecialchars($error); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php unset($_SESSION['form_errors']); ?>
    <?php endif; ?>

    <div class="bg-white shadow rounded-lg p-6">
        <form action="<?php echo BASE_URL; ?>/admin/services/<?php echo $service['id']; ?>/update" method="POST" enctype="multipart/form-data">
            <?php echo csrf_token(); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Basic Information -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold mb-4">Basic Information</h3>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Service Name *</label>
                    <input type="text" name="name" required
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['name'] ?? $service['name']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Category</label>
                    <select name="category_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="">Select Category</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category['id']; ?>"
                                    <?php echo ($_SESSION['form_data']['category_id'] ?? $service['category_id']) == $category['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($category['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700">Short Description</label>
                    <input type="text" name="short_description"
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['short_description'] ?? $service['short_description']); ?>"
                           maxlength="255" placeholder="Brief description for listings..."
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700">Full Description</label>
                    <textarea name="description" rows="4"
                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($_SESSION['form_data']['description'] ?? $service['description']); ?></textarea>
                </div>

                <!-- Pricing and Duration -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold mb-4">Pricing & Duration</h3>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Price ($) *</label>
                    <input type="number" name="price" step="0.01" min="0" required
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['price'] ?? $service['price']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Duration (minutes) *</label>
                    <input type="number" name="duration_minutes" min="1" required
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['duration_minutes'] ?? $service['duration_minutes']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Preparation Time (minutes)</label>
                    <input type="number" name="preparation_time" min="0"
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['preparation_time'] ?? $service['preparation_time']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Cleanup Time (minutes)</label>
                    <input type="number" name="cleanup_time" min="0"
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['cleanup_time'] ?? $service['cleanup_time']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <!-- Settings -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold mb-4">Settings</h3>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Maximum Capacity</label>
                    <input type="number" name="max_capacity" min="1"
                           value="<?php echo htmlspecialchars($_SESSION['form_data']['max_capacity'] ?? $service['max_capacity']); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <p class="mt-1 text-xs text-gray-500">How many customers can be served simultaneously</p>
                </div>

                <div class="space-y-3">
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" value="1"
                               <?php echo ($_SESSION['form_data']['is_active'] ?? $service['is_active']) ? 'checked' : ''; ?>
                               class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                        <label class="ml-2 block text-sm text-gray-900">
                            Active (visible to customers)
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="is_featured" value="1"
                               <?php echo ($_SESSION['form_data']['is_featured'] ?? $service['is_featured']) ? 'checked' : ''; ?>
                               class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                        <label class="ml-2 block text-sm text-gray-900">
                            Featured (highlight on homepage)
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="requires_staff" value="1"
                               <?php echo ($_SESSION['form_data']['requires_staff'] ?? $service['requires_staff']) ? 'checked' : ''; ?>
                               class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                        <label class="ml-2 block text-sm text-gray-900">
                            Requires Staff Assignment
                        </label>
                    </div>
                </div>

                <!-- Image Upload -->
                <div class="md:col-span-2">
                    <h3 class="text-lg font-semibold mb-4">Service Image</h3>

                    <?php if ($service['image']): ?>
                        <div class="mb-4">
                            <img src="<?php echo htmlspecialchars($service['image']); ?>" alt="Current service image"
                                 class="w-32 h-32 object-cover rounded-lg border">
                        </div>
                    <?php endif; ?>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Upload New Image</label>
                        <input type="file" name="image" accept="image/*"
                               class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                        <p class="mt-1 text-xs text-gray-500">PNG, JPG, GIF up to 5MB</p>
                    </div>
                </div>
            </div>

            <div class="mt-8 flex justify-end space-x-4">
                <a href="<?php echo BASE_URL; ?>/admin/services" class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                    Cancel
                </a>
                <button type="submit" class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700">
                    Update Service
                </button>
            </div>
        </form>
    </div>
</div>

<?php unset($_SESSION['form_data']); ?>
