<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Admin Dashboard - Salon Management System">
    <meta name="author" content="Salon System">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo ASSETS_URL; ?>/images/favicon.ico">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <link href="<?php echo ASSETS_URL; ?>/css/tailwind.css" rel="stylesheet">

    <!-- Admin CSS -->
    <link href="<?php echo ASSETS_URL; ?>/css/admin.css" rel="stylesheet">

    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>Admin Dashboard</title>

    <!-- Chart.js for analytics -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-100 font-['Inter']">
    <!-- Top Navigation -->
    <nav class="bg-white shadow-sm border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <!-- Logo and Brand -->
                <div class="flex items-center">
                    <div class="flex-shrink-0 flex items-center">
                        <img src="<?php echo ASSETS_URL; ?>/images/logo.png" alt="Logo" class="h-8 w-auto" onerror="this.src='<?php echo ASSETS_URL; ?>/images/logo-placeholder.png'">
                        <span class="ml-2 text-xl font-semibold text-gray-900">Admin</span>
                    </div>
                </div>

                <!-- Right side actions -->
                <div class="flex items-center space-x-4">
                    <!-- Notifications -->
                    <button class="p-2 text-gray-400 hover:text-gray-600 relative">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5-5V7a3 3 0 00-6 0v5l-5 5h5m0 0v1a3 3 0 006 0v-1m-6 0h6"/>
                        </svg>
                        <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-400"></span>
                    </button>

                    <!-- User Menu -->
                    <div class="relative" id="user-menu">
                        <button class="flex items-center space-x-2 text-gray-700 hover:text-gray-900 p-2 rounded-md hover:bg-gray-100" id="user-menu-button">
                            <img class="w-8 h-8 rounded-full" src="<?php echo getAvatarUrl($user['avatar']); ?>" alt="<?php echo htmlspecialchars($user['first_name']); ?>">
                            <span class="hidden md:block"><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></span>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>

                        <div class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50 opacity-0 invisible transition-all duration-200" id="user-menu-dropdown">
                            <a href="<?php echo BASE_URL; ?>/profile" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                Profile
                            </a>
                            <a href="<?php echo BASE_URL; ?>/settings" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                Settings
                            </a>
                            <div class="border-t border-gray-100"></div>
                            <a href="<?php echo BASE_URL; ?>/logout" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                </svg>
                                Logout
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <div class="flex">
        <!-- Sidebar -->
        <div class="w-64 bg-white shadow-sm min-h-screen border-r border-gray-200">
            <nav class="mt-8">
                <div class="px-4 space-y-2">
                    <!-- Dashboard -->
                    <a href="<?php echo BASE_URL; ?>/admin/dashboard" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/dashboard') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/dashboard') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v0M8 5a2 2 0 012-2h4a2 2 0 012 2v0"/>
                        </svg>
                        Dashboard
                    </a>

                    <!-- Bookings -->
                    <a href="<?php echo BASE_URL; ?>/admin/bookings" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/bookings') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/bookings') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 4v10a2 2 0 002 2h4a2 2 0 002-2V11M9 11h6"/>
                        </svg>
                        Bookings
                    </a>

                    <!-- Services -->
                    <a href="<?php echo BASE_URL; ?>/admin/services" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/services') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/services') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                        </svg>
                        Services
                    </a>

                    <!-- Staff -->
                    <a href="<?php echo BASE_URL; ?>/admin/staff" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/staff') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/staff') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        Staff
                    </a>

                    <!-- Customers -->
                    <a href="<?php echo BASE_URL; ?>/admin/customers" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/customers') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/customers') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"/>
                        </svg>
                        Customers
                    </a>

                    <!-- Reports -->
                    <a href="<?php echo BASE_URL; ?>/admin/reports" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/reports') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/reports') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                        Reports
                    </a>

                    <!-- Settings -->
                    <a href="<?php echo BASE_URL; ?>/admin/settings" class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/settings') !== false ? 'bg-amber-100 text-amber-900' : 'text-gray-700 hover:bg-gray-100'; ?>">
                        <svg class="mr-3 h-5 w-5 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/settings') !== false ? 'text-amber-500' : 'text-gray-400'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                        Settings
                    </a>
                </div>

                <!-- Quick Actions -->
                <div class="mt-8 px-4">
                    <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-3">Quick Actions</h3>
                    <div class="space-y-2">
                        <a href="<?php echo BASE_URL; ?>/admin/bookings/create" class="flex items-center px-3 py-2 text-sm text-gray-700 hover:bg-gray-100 rounded-md">
                            <svg class="mr-2 h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                            </svg>
                            New Booking
                        </a>
                        <a href="<?php echo BASE_URL; ?>/admin/services/create" class="flex items-center px-3 py-2 text-sm text-gray-700 hover:bg-gray-100 rounded-md">
                            <svg class="mr-2 h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                            </svg>
                            Add Service
                        </a>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1">
            <!-- Flash Messages -->
            <?php if ($flashMessage): ?>
                <div class="m-4 p-4">
                    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-4">
                        <div class="bg-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-50 border border-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-200 text-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-800 px-4 py-3 rounded-md">
                            <?php echo htmlspecialchars($flashMessage['message']); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <main class="p-8">

