<?php
/**
 * Admin Dashboard Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Dashboard</h1>
        <div class="text-sm text-gray-600">
            Welcome back, <?php echo htmlspecialchars($this->auth->firstName()); ?>!
        </div>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <!-- Quick Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">New Bookings</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($newBookings ?? 0); ?></p>
                    <p class="text-sm text-gray-500">Today</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Today's Bookings</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($todayBookings ?? 0); ?></p>
                    <p class="text-sm text-gray-500">Scheduled</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-yellow-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Revenue</h3>
                    <p class="text-2xl font-bold text-gray-700">$<?php echo number_format($todayRevenue ?? 0, 2); ?></p>
                    <p class="text-sm text-gray-500">Today</p>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-purple-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">New Clients</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($newClients ?? 0); ?></p>
                    <p class="text-sm text-gray-500">This month</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-white shadow rounded-lg p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-2">Top Hours</h3>
            <div class="space-y-2">
                <?php
                $topHours = $topHours ?? [
                    ['hour' => '10:00 AM', 'bookings' => 8],
                    ['hour' => '2:00 PM', 'bookings' => 6],
                    ['hour' => '11:00 AM', 'bookings' => 5]
                ];
                foreach ($topHours as $hour): ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm"><?php echo $hour['hour']; ?></span>
                        <span class="text-sm font-medium"><?php echo $hour['bookings']; ?> bookings</span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-2">Active Staff</h3>
            <div class="space-y-2">
                <?php
                $activeStaff = $activeStaff ?? [
                    ['name' => 'Sarah Johnson', 'status' => 'Available'],
                    ['name' => 'Mike Chen', 'status' => 'In Service'],
                    ['name' => 'Emma Davis', 'status' => 'Available']
                ];
                foreach ($activeStaff as $staff): ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm"><?php echo htmlspecialchars($staff['name']); ?></span>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                            <?php echo $staff['status'] === 'Available' ? 'bg-green-100 text-green-800' :
                                ($staff['status'] === 'In Service' ? 'bg-blue-100 text-blue-800' :
                                'bg-gray-100 text-gray-800'); ?>">
                            <?php echo $staff['status']; ?>
                        </span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-2">Pending Payments</h3>
            <div class="space-y-2">
                <?php
                $pendingPayments = $pendingPayments ?? [
                    ['amount' => 150.00, 'days' => 2],
                    ['amount' => 89.50, 'days' => 5],
                    ['amount' => 200.00, 'days' => 7]
                ];
                foreach ($pendingPayments as $payment): ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm">$<?php echo number_format($payment['amount'], 2); ?></span>
                        <span class="text-xs text-orange-600"><?php echo $payment['days']; ?> days overdue</span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white shadow rounded-lg p-6 mb-8">
        <h2 class="text-xl font-semibold mb-4">Quick Actions</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="<?php echo BASE_URL; ?>/admin/bookings/create" class="flex flex-col items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <svg class="w-8 h-8 text-blue-600 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                <span class="text-sm font-medium">Create Booking</span>
            </a>

            <a href="<?php echo BASE_URL; ?>/admin/staff/create" class="flex flex-col items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <svg class="w-8 h-8 text-green-600 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                <span class="text-sm font-medium">Add Staff</span>
            </a>

            <a href="<?php echo BASE_URL; ?>/admin/services/create" class="flex flex-col items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <svg class="w-8 h-8 text-purple-600 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
                <span class="text-sm font-medium">Add Service</span>
            </a>

            <a href="<?php echo BASE_URL; ?>/admin/reports" class="flex flex-col items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <svg class="w-8 h-8 text-orange-600 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
                <span class="text-sm font-medium">View Reports</span>
            </a>
        </div>
    </div>

    <!-- Recent Bookings -->
    <div class="bg-white shadow rounded-lg p-6 mb-8">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-semibold">Recent Bookings</h2>
            <a href="<?php echo BASE_URL; ?>/admin/bookings" class="text-indigo-600 hover:text-indigo-800 text-sm">View All</a>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Booking #</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Service</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date & Time</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php
                    $recentBookings = $recentBookings ?? [];
                    foreach ($recentBookings as $booking): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                <?php echo htmlspecialchars($booking['booking_number'] ?? 'BK-' . $booking['id']); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php echo htmlspecialchars(($booking['customer_first_name'] ?? '') . ' ' . ($booking['customer_last_name'] ?? '')); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php echo htmlspecialchars($booking['service_name'] ?? ''); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php echo $booking['start_at'] ? formatDateTime($booking['start_at']) : 'Not set'; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php echo ($booking['status'] ?? '') === 'confirmed' ? 'bg-blue-100 text-blue-800' :
                                        (($booking['status'] ?? '') === 'completed' ? 'bg-green-100 text-green-800' :
                                        (($booking['status'] ?? '') === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                        'bg-red-100 text-red-800')); ?>">
                                    <?php echo ucfirst($booking['status'] ?? 'unknown'); ?>
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <a href="<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>" class="text-indigo-600 hover:text-indigo-900">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Notifications Center -->
    <div class="bg-white shadow rounded-lg p-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-semibold">Recent Notifications</h2>
            <a href="<?php echo BASE_URL; ?>/admin/notifications" class="text-indigo-600 hover:text-indigo-800 text-sm">View All</a>
        </div>
        <div class="space-y-4">
            <?php
            $notifications = $notifications ?? [
                ['type' => 'booking', 'message' => 'New booking from John Doe for Hair Styling', 'time' => '2 hours ago'],
                ['type' => 'payment', 'message' => 'Payment received for booking #BK-001', 'time' => '4 hours ago'],
                ['type' => 'staff', 'message' => 'Sarah Johnson checked in for her shift', 'time' => '6 hours ago']
            ];
            foreach ($notifications as $notification): ?>
                <div class="flex items-start space-x-3">
                    <div class="flex-shrink-0">
                        <div class="w-2 h-2 bg-blue-500 rounded-full mt-2"></div>
                    </div>
                    <div class="flex-1">
                        <p class="text-sm text-gray-900"><?php echo htmlspecialchars($notification['message']); ?></p>
                        <p class="text-xs text-gray-500"><?php echo $notification['time']; ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>