<?php
/**
 * Staff Middleware
 * Salon/Spa/Beauty Parlor Booking System
 */

class StaffMiddleware {
    public static function handle() {
        $auth = Auth::getInstance();

        if (!$auth->check()) {
            if (isAjaxRequest()) {
                jsonResponse(['error' => 'Authentication required'], 401);
            } else {
                redirectWithMessage(BASE_URL . '/login', 'Please log in to access this page.', 'warning');
            }
        }

        if (!$auth->isStaff() && !$auth->isAdmin()) {
            if (isAjaxRequest()) {
                jsonResponse(['error' => 'Staff privileges required'], 403);
            } else {
                redirectWithMessage(BASE_URL . '/dashboard', 'Access denied. Staff privileges required.', 'danger');
            }
        }
    }
}
