<?php
/**
 * Authentication Middleware
 * Salon/Spa/Beauty Parlor Booking System
 */

class AuthMiddleware {
    public static function handle() {
        $auth = Auth::getInstance();

        if (!$auth->check()) {
            redirectWithMessage(BASE_URL . '/login', 'Please log in to access this page.', 'warning');
        }
    }

    public static function admin() {
        $auth = Auth::getInstance();

        self::handle(); // Ensure user is logged in

        if (!$auth->isAdmin()) {
            redirectWithMessage(BASE_URL . '/dashboard', 'Access denied. Admin privileges required.', 'danger');
        }
    }

    public static function staff() {
        $auth = Auth::getInstance();

        self::handle(); // Ensure user is logged in

        if (!$auth->isStaff() && !$auth->isAdmin()) {
            redirectWithMessage(BASE_URL . '/dashboard', 'Access denied. Staff privileges required.', 'danger');
        }
    }

    public static function customer() {
        $auth = Auth::getInstance();

        self::handle(); // Ensure user is logged in

        if (!$auth->isCustomer() && !$auth->isAdmin()) {
            redirectWithMessage(BASE_URL . '/dashboard', 'Access denied.', 'danger');
        }
    }
}
