<?php
/**
 * Base Controller Class
 * Salon/Spa/Beauty Parlor Booking System
 */

class Controller {
    protected $auth;
    protected $db;

    public function __construct() {
        $this->auth = Auth::getInstance();
        $this->db = Database::getInstance();
    }

    /**
     * Render a view
     */
    protected function view($view, $data = []) {
        // Extract data to variables
        extract($data);

        // Set common variables
        $auth = $this->auth;
        $user = $auth->user();
        $flashMessage = getFlashMessage();
        $csrfToken = generateCsrfToken();

        // Include header
        $headerFile = SRC_PATH . '/Views/layouts/header.php';
        if (file_exists($headerFile)) {
            include $headerFile;
        }

        // Include view
        $viewFile = SRC_PATH . '/Views/' . $view . '.php';
        if (file_exists($viewFile)) {
            include $viewFile;
        } else {
            throw new Exception("View file not found: {$viewFile}");
        }

        // Include footer
        $footerFile = SRC_PATH . '/Views/layouts/footer.php';
        if (file_exists($footerFile)) {
            include $footerFile;
        }
    }

    /**
     * Render admin view
     */
    protected function adminView($view, $data = []) {
        // Extract data to variables
        extract($data);

        // Set common variables
        $auth = $this->auth;
        $user = $auth->user();
        $flashMessage = getFlashMessage();
        $csrfToken = generateCsrfToken();

        // Include admin header
        $headerFile = SRC_PATH . '/Views/admin/layouts/header.php';
        if (file_exists($headerFile)) {
            include $headerFile;
        }

        // Include view
        $viewFile = SRC_PATH . '/Views/admin/' . $view . '.php';
        if (file_exists($viewFile)) {
            include $viewFile;
        } else {
            throw new Exception("Admin view file not found: {$viewFile}");
        }

        // Include admin footer
        $footerFile = SRC_PATH . '/Views/admin/layouts/footer.php';
        if (file_exists($footerFile)) {
            include $footerFile;
        }
    }

    /**
     * Render staff view
     */
    protected function staffView($view, $data = []) {
        // Extract data to variables
        extract($data);

        // Set common variables
        $auth = $this->auth;
        $user = $auth->user();
        $flashMessage = getFlashMessage();
        $csrfToken = generateCsrfToken();

        // Include staff header
        $headerFile = SRC_PATH . '/Views/staff/layouts/header.php';
        if (file_exists($headerFile)) {
            include $headerFile;
        }

        // Include view
        $viewFile = SRC_PATH . '/Views/staff/' . $view . '.php';
        if (file_exists($viewFile)) {
            include $viewFile;
        } else {
            throw new Exception("Staff view file not found: {$viewFile}");
        }

        // Include staff footer
        $footerFile = SRC_PATH . '/Views/staff/layouts/footer.php';
        if (file_exists($footerFile)) {
            include $footerFile;
        }
    }

    /**
     * Return JSON response
     */
    protected function json($data, $statusCode = 200) {
        jsonResponse($data, $statusCode);
    }

    /**
     * Redirect to URL
     */
    protected function redirect($url, $message = null, $type = 'success') {
        if ($message) {
            redirectWithMessage($url, $message, $type);
        } else {
            header("Location: $url");
            exit;
        }
    }

    /**
     * Check if request is AJAX
     */
    protected function isAjax() {
        return isAjaxRequest();
    }

    /**
     * Get POST data
     */
    protected function getPost($key = null, $default = null) {
        if ($key === null) {
            return $_POST;
        }
        return getPostParam($key, $default);
    }

    /**
     * Get GET data
     */
    protected function getQuery($key = null, $default = null) {
        if ($key === null) {
            return $_GET;
        }
        return getQueryParam($key, $default);
    }

    /**
     * Validate required fields
     */
    protected function validateRequired($data, $fields) {
        $errors = [];
        foreach ($fields as $field) {
            if (!isset($data[$field]) || empty(trim($data[$field]))) {
                $errors[$field] = ucfirst(str_replace('_', ' ', $field)) . ' is required';
            }
        }
        return $errors;
    }

    /**
     * Validate email
     */
    protected function validateEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }

    /**
     * Sanitize input
     */
    protected function sanitize($data) {
        if (is_array($data)) {
            return array_map([$this, 'sanitize'], $data);
        }
        return sanitize($data);
    }
}
