<?php
/**
 * Application Routes
 * Salon/Spa/Beauty Parlor Booking System
 */

use Controllers\HomeController;
use Controllers\ServiceController;
use Controllers\BookingController;
use Controllers\AuthController;
use Controllers\Admin\DashboardController;
use Controllers\Admin\BookingController as AdminBookingController;
use Controllers\Admin\ServiceController as AdminServiceController;
use Controllers\Admin\StaffController as AdminStaffController;
use Controllers\Admin\CustomerController as AdminCustomerController;
use Controllers\Admin\ReportController as AdminReportController;
use Controllers\Admin\SettingController as AdminSettingController;
use Controllers\Staff\DashboardController as StaffDashboardController;
use Controllers\Staff\ScheduleController as StaffScheduleController;
use Controllers\Staff\BookingController as StaffBookingController;
use Controllers\Shop\CatalogController;
use Controllers\Shop\CartController;
use Controllers\Shop\CheckoutController;
use Controllers\Api\ServiceController as ApiServiceController;
use Controllers\Api\BranchController as ApiBranchController;
use Controllers\Api\AvailabilityController as ApiAvailabilityController;
use Controllers\Api\BookingController as ApiBookingController;
use Controllers\Api\AuthController as ApiAuthController;
use Middleware\AuthMiddleware;
use Middleware\AdminMiddleware;
use Middleware\StaffMiddleware;

// Public routes
$router->get('/', [HomeController::class, 'index']);
$router->get('/services', [ServiceController::class, 'index']);
$router->get('/services/{slug}', [ServiceController::class, 'show']);
$router->get('/book', [BookingController::class, 'create']);
$router->post('/book', [BookingController::class, 'store']);
$router->get('/login', [AuthController::class, 'login']);
$router->post('/login', [AuthController::class, 'doLogin']);
$router->get('/register', [AuthController::class, 'register']);
$router->post('/register', [AuthController::class, 'doRegister']);
$router->post('/logout', [AuthController::class, 'logout']);

// API routes
$router->group('/api', function($router) {
    $router->get('/services', [ApiServiceController::class, 'index']);
    $router->get('/services/{slug}', [ApiServiceController::class, 'show']);
    $router->get('/branches', [ApiBranchController::class, 'index']);
    $router->get('/availability', [ApiAvailabilityController::class, 'check']);
    $router->post('/bookings', [ApiBookingController::class, 'store']);
    $router->post('/auth/login', [ApiAuthController::class, 'login']);
    $router->post('/auth/register', [ApiAuthController::class, 'register']);
});

// Admin routes
$router->group('/admin', function($router) {
    $router->middleware([AdminMiddleware::class, 'handle']);
    $router->get('/', [AdminDashboardController::class, 'index']);
    $router->get('/dashboard', [AdminDashboardController::class, 'index']);
    $router->get('/bookings', [AdminBookingController::class, 'index']);
    $router->get('/bookings/{id}', [AdminBookingController::class, 'show']);
    $router->post('/bookings/{id}/status', [AdminBookingController::class, 'updateStatus']);
    $router->get('/services', [AdminServiceController::class, 'index']);
    $router->get('/services/create', [AdminServiceController::class, 'create']);
    $router->post('/services', [AdminServiceController::class, 'store']);
    $router->get('/services/{id}/edit', [AdminServiceController::class, 'edit']);
    $router->post('/services/{id}', [AdminServiceController::class, 'update']);
    $router->delete('/services/{id}', [AdminServiceController::class, 'destroy']);
    $router->get('/staff', [AdminStaffController::class, 'index']);
    $router->get('/customers', [AdminCustomerController::class, 'index']);
    $router->get('/reports', [AdminReportController::class, 'index']);
    $router->get('/settings', [AdminSettingController::class, 'index']);
    $router->post('/settings', [AdminSettingController::class, 'update']);
}, [AuthMiddleware::class, 'admin']);

// Staff routes
$router->group('/staff', function($router) {
    $router->middleware([StaffMiddleware::class, 'handle']);
    $router->get('/', [StaffDashboardController::class, 'index']);
    $router->get('/dashboard', [StaffDashboardController::class, 'index']);
    $router->get('/schedule', [StaffScheduleController::class, 'index']);
    $router->get('/bookings', [StaffBookingController::class, 'index']);
    $router->get('/bookings/{id}', [StaffBookingController::class, 'show']);
    $router->post('/bookings/{id}/status', [StaffBookingController::class, 'updateStatus']);
}, [AuthMiddleware::class, 'staff']);

// Shop routes
$router->group('/shop', function($router) {
    $router->get('/', [CatalogController::class, 'index']);
    $router->get('/products/{slug}', [CatalogController::class, 'show']);
    $router->get('/cart', [CartController::class, 'index']);
    $router->post('/cart/add', [CartController::class, 'add']);
    $router->post('/cart/update', [CartController::class, 'update']);
    $router->delete('/cart/{id}', [CartController::class, 'remove']);
    $router->get('/checkout', [CheckoutController::class, 'index']);
    $router->post('/checkout', [CheckoutController::class, 'process']);
});
