<?php
/**
 * Staff Schedule Availability View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">My Availability</h1>
        <a href="<?php echo BASE_URL; ?>/staff/schedule" class="text-indigo-600 hover:text-indigo-800">
            ← Back to Schedule
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <form action="<?php echo BASE_URL; ?>/staff/schedule/availability/update" method="POST" class="space-y-6">
        <?php echo csrf_token(); ?>

        <!-- Monday to Friday -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Weekday Availability (Monday - Friday)</h2>
            <div class="space-y-4">
                <?php
                $weekdays = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday'];
                $dayNames = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
                ?>

                <?php foreach ($weekdays as $index => $day): ?>
                    <div class="border rounded-lg p-4">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-medium"><?php echo $dayNames[$index]; ?></h3>
                            <label class="flex items-center">
                                <input type="checkbox" name="<?php echo $day; ?>_enabled" value="1"
                                       <?php echo isset($availabilityByDay[$index]) ? 'checked' : ''; ?>
                                       onchange="toggleDayAvailability('<?php echo $day; ?>', this.checked)"
                                       class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Available</span>
                            </label>
                        </div>

                        <div id="<?php echo $day; ?>_times" class="grid grid-cols-1 md:grid-cols-3 gap-4 <?php echo !isset($availabilityByDay[$index]) ? 'hidden' : ''; ?>">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Start Time</label>
                                <input type="time" name="<?php echo $day; ?>_start"
                                       value="<?php echo $availabilityByDay[$index][0]['start_time'] ?? '09:00'; ?>"
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">End Time</label>
                                <input type="time" name="<?php echo $day; ?>_end"
                                       value="<?php echo $availabilityByDay[$index][0]['end_time'] ?? '17:00'; ?>"
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Break (Optional)</label>
                                <div class="flex space-x-2">
                                    <input type="time" name="<?php echo $day; ?>_break_start" placeholder="Start"
                                           value="<?php echo $availabilityByDay[$index][0]['break_start'] ?? ''; ?>"
                                           class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <input type="time" name="<?php echo $day; ?>_break_end" placeholder="End"
                                           value="<?php echo $availabilityByDay[$index][0]['break_end'] ?? ''; ?>"
                                           class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Weekend -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Weekend Availability</h2>
            <div class="space-y-4">
                <?php
                $weekends = ['saturday', 'sunday'];
                $weekendNames = ['Saturday', 'Sunday'];
                ?>

                <?php foreach ($weekends as $index => $day): ?>
                    <?php $dayIndex = $index + 5; // Saturday = 5, Sunday = 6 ?>
                    <div class="border rounded-lg p-4">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-medium"><?php echo $weekendNames[$index]; ?></h3>
                            <label class="flex items-center">
                                <input type="checkbox" name="<?php echo $day; ?>_enabled" value="1"
                                       <?php echo isset($availabilityByDay[$dayIndex]) ? 'checked' : ''; ?>
                                       onchange="toggleDayAvailability('<?php echo $day; ?>', this.checked)"
                                       class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Available</span>
                            </label>
                        </div>

                        <div id="<?php echo $day; ?>_times" class="grid grid-cols-1 md:grid-cols-3 gap-4 <?php echo !isset($availabilityByDay[$dayIndex]) ? 'hidden' : ''; ?>">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Start Time</label>
                                <input type="time" name="<?php echo $day; ?>_start"
                                       value="<?php echo $availabilityByDay[$dayIndex][0]['start_time'] ?? '09:00'; ?>"
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">End Time</label>
                                <input type="time" name="<?php echo $day; ?>_end"
                                       value="<?php echo $availabilityByDay[$dayIndex][0]['end_time'] ?? '17:00'; ?>"
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Break (Optional)</label>
                                <div class="flex space-x-2">
                                    <input type="time" name="<?php echo $day; ?>_break_start" placeholder="Start"
                                           value="<?php echo $availabilityByDay[$dayIndex][0]['break_start'] ?? ''; ?>"
                                           class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <input type="time" name="<?php echo $day; ?>_break_end" placeholder="End"
                                           value="<?php echo $availabilityByDay[$dayIndex][0]['break_end'] ?? ''; ?>"
                                           class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Special Notes -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Additional Notes</h2>
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Availability Notes</label>
                    <textarea name="availability_notes" rows="3" placeholder="Any special notes about your availability..."
                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($staff['availability_notes'] ?? ''); ?></textarea>
                    <p class="mt-1 text-sm text-gray-500">These notes will be visible to administrators when scheduling.</p>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div class="flex justify-end">
            <button type="submit" class="bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700 text-lg font-medium">
                Update Availability
            </button>
        </div>
    </form>

    <!-- Current Schedule Summary -->
    <div class="bg-white shadow rounded-lg p-6 mt-8">
        <h2 class="text-xl font-semibold mb-4">Current Schedule Summary</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <?php
            $daysOfWeek = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
            foreach ($daysOfWeek as $index => $dayName): ?>
                <div class="border rounded-lg p-4">
                    <h3 class="font-medium text-gray-900"><?php echo $dayName; ?></h3>
                    <?php if (isset($availabilityByDay[$index])): ?>
                        <p class="text-sm text-green-600">Available</p>
                        <p class="text-sm text-gray-600">
                            <?php echo date('g:i A', strtotime($availabilityByDay[$index][0]['start_time'])); ?> -
                            <?php echo date('g:i A', strtotime($availabilityByDay[$index][0]['end_time'])); ?>
                        </p>
                        <?php if ($availabilityByDay[$index][0]['break_start']): ?>
                            <p class="text-sm text-orange-600">
                                Break: <?php echo date('g:i A', strtotime($availabilityByDay[$index][0]['break_start'])); ?> -
                                <?php echo date('g:i A', strtotime($availabilityByDay[$index][0]['break_end'])); ?>
                            </p>
                        <?php endif; ?>
                    <?php else: ?>
                        <p class="text-sm text-red-600">Not Available</p>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
function toggleDayAvailability(day, isChecked) {
    const timesDiv = document.getElementById(day + '_times');
    if (isChecked) {
        timesDiv.classList.remove('hidden');
    } else {
        timesDiv.classList.add('hidden');
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    // Set initial states
    const days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
    days.forEach(day => {
        const checkbox = document.querySelector(`input[name="${day}_enabled"]`);
        if (checkbox) {
            toggleDayAvailability(day, checkbox.checked);
        }
    });
});
</script>
