<?php
/**
 * Staff Dashboard Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Staff Dashboard</h1>
        <div class="text-sm text-gray-600">
            Welcome back, <?php echo htmlspecialchars($this->auth->firstName()); ?>!
        </div>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <!-- Today's Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Today's Bookings</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($todayStats['total_bookings']); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Completed</h3>
                    <p class="text-2xl font-bold text-gray-700"><?php echo number_format($todayStats['completed_bookings']); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-yellow-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Today's Revenue</h3>
                    <p class="text-2xl font-bold text-gray-700">$<?php echo number_format($todayStats['revenue'], 2); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-purple-500 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-medium text-gray-900">Attendance</h3>
                    <p class="text-sm text-gray-500">
                        <?php if ($todayStats['attendance']): ?>
                            <?php if ($todayStats['attendance']['clock_out']): ?>
                                Clocked out at <?php echo date('H:i', strtotime($todayStats['attendance']['clock_out'])); ?>
                            <?php else: ?>
                                Clocked in at <?php echo date('H:i', strtotime($todayStats['attendance']['clock_in'])); ?>
                            <?php endif; ?>
                        <?php else: ?>
                            Not clocked in today
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Clock In/Out Button -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-xl font-semibold mb-2">Attendance</h2>
                <div id="attendance-status" class="text-sm text-gray-600">
                    <!-- Status will be loaded via AJAX -->
                </div>
            </div>
            <div class="flex space-x-4">
                <button id="clock-in-btn" onclick="clockIn()" class="bg-green-600 text-white px-6 py-2 rounded-md hover:bg-green-700 hidden">
                    Clock In
                </button>
                <button id="clock-out-btn" onclick="clockOut()" class="bg-red-600 text-white px-6 py-2 rounded-md hover:bg-red-700 hidden">
                    Clock Out
                </button>
            </div>
        </div>
    </div>

    <!-- Today's Schedule -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <h2 class="text-xl font-semibold mb-4">Today's Schedule</h2>
        <?php if (empty($todaySchedule)): ?>
            <p class="text-gray-500">No appointments scheduled for today.</p>
        <?php else: ?>
            <div class="space-y-4">
                <?php foreach ($todaySchedule as $booking): ?>
                    <div class="border-l-4 border-blue-500 pl-4 py-2">
                        <div class="flex justify-between items-start">
                            <div>
                                <h3 class="font-medium"><?php echo htmlspecialchars($booking['service_name']); ?></h3>
                                <p class="text-sm text-gray-600">
                                    <?php echo htmlspecialchars($booking['customer_id'] ? $booking['first_name'] . ' ' . $booking['last_name'] : 'Guest'); ?>
                                </p>
                                <p class="text-sm text-gray-600">
                                    <?php echo htmlspecialchars($booking['phone']); ?>
                                </p>
                            </div>
                            <div class="text-right">
                                <p class="font-medium"><?php echo date('H:i', strtotime($booking['start_at'])); ?> - <?php echo date('H:i', strtotime($booking['start_at'] . ' +' . $booking['duration_minutes'] . ' minutes')); ?></p>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php echo $booking['status'] === 'confirmed' ? 'bg-blue-100 text-blue-800' :
                                        ($booking['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                        ($booking['status'] === 'completed' ? 'bg-green-100 text-green-800' :
                                        'bg-red-100 text-red-800')); ?>">
                                    <?php echo ucfirst($booking['status']); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Upcoming Bookings -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <h2 class="text-xl font-semibold mb-4">Upcoming Appointments</h2>
        <?php if (empty($upcomingBookings)): ?>
            <p class="text-gray-500">No upcoming appointments.</p>
        <?php else: ?>
            <div class="space-y-4">
                <?php foreach ($upcomingBookings as $booking): ?>
                    <div class="border-l-4 border-green-500 pl-4 py-2">
                        <div class="flex justify-between items-start">
                            <div>
                                <h3 class="font-medium"><?php echo htmlspecialchars($booking['service_name']); ?></h3>
                                <p class="text-sm text-gray-600">
                                    <?php echo htmlspecialchars($booking['customer_id'] ? $booking['first_name'] . ' ' . $booking['last_name'] : 'Guest'); ?>
                                </p>
                                <p class="text-sm text-gray-600">
                                    <?php echo htmlspecialchars($booking['branch_name']); ?>
                                </p>
                            </div>
                            <div class="text-right">
                                <p class="font-medium"><?php echo formatDateTime($booking['start_at']); ?></p>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php echo $booking['status'] === 'confirmed' ? 'bg-blue-100 text-blue-800' :
                                        ($booking['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                        ($booking['status'] === 'completed' ? 'bg-green-100 text-green-800' :
                                        'bg-red-100 text-red-800')); ?>">
                                    <?php echo ucfirst($booking['status']); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Weekly Schedule Overview -->
    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-semibold mb-4">This Week Overview</h2>
        <div class="grid grid-cols-7 gap-4">
            <?php
            $days = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
            foreach ($weeklySchedule as $index => $day): ?>
                <div class="text-center p-4 border rounded-lg <?php echo $day['is_available'] ? 'bg-green-50 border-green-200' : 'bg-gray-50 border-gray-200'; ?>">
                    <h3 class="font-medium text-sm"><?php echo $days[$index]; ?></h3>
                    <p class="text-xs text-gray-600"><?php echo date('M j', strtotime($day['date'])); ?></p>
                    <p class="text-lg font-bold <?php echo $day['booking_count'] > 0 ? 'text-blue-600' : 'text-gray-400'; ?>">
                        <?php echo $day['booking_count']; ?>
                    </p>
                    <p class="text-xs <?php echo $day['is_available'] ? 'text-green-600' : 'text-red-600'; ?>">
                        <?php echo $day['is_available'] ? 'Available' : 'Unavailable'; ?>
                    </p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
function loadAttendanceStatus() {
    fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance-status')
        .then(response => response.json())
        .then(data => {
            const status = data.status;
            const statusDiv = document.getElementById('attendance-status');
            const clockInBtn = document.getElementById('clock-in-btn');
            const clockOutBtn = document.getElementById('clock-out-btn');

            if (status.is_clocked_in) {
                statusDiv.innerHTML = `Clocked in at ${status.clock_in_time}`;
                clockOutBtn.classList.remove('hidden');
                clockInBtn.classList.add('hidden');
            } else if (status.can_clock_in) {
                statusDiv.innerHTML = 'Not clocked in today';
                clockInBtn.classList.remove('hidden');
                clockOutBtn.classList.add('hidden');
            } else {
                statusDiv.innerHTML = 'Attendance completed for today';
                clockInBtn.classList.add('hidden');
                clockOutBtn.classList.add('hidden');
            }
        })
        .catch(error => {
            console.error('Error loading attendance status:', error);
        });
}

function clockIn() {
    fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=clock_in'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            loadAttendanceStatus();
        } else {
            alert(data.message || 'Failed to clock in');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to clock in');
    });
}

function clockOut() {
    fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=clock_out'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            loadAttendanceStatus();
        } else {
            alert(data.message || 'Failed to clock out');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to clock out');
    });
}

// Load attendance status on page load
document.addEventListener('DOMContentLoaded', loadAttendanceStatus);
</script>
