<?php
/**
 * Shop Cart Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Shopping Cart</h1>
        <a href="<?php echo BASE_URL; ?>/shop" class="text-indigo-600 hover:text-indigo-800">
            Continue Shopping
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <?php if (empty($cartItems)): ?>
        <!-- Empty Cart -->
        <div class="text-center py-12">
            <svg class="mx-auto h-24 w-24 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
            </svg>
            <h3 class="mt-2 text-lg font-medium text-gray-900">Your cart is empty</h3>
            <p class="mt-1 text-gray-500">Start adding some products to your cart.</p>
            <div class="mt-6">
                <a href="<?php echo BASE_URL; ?>/shop" class="bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700">
                    Browse Products
                </a>
            </div>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Cart Items -->
            <div class="lg:col-span-2">
                <div class="bg-white shadow rounded-lg p-6">
                    <h2 class="text-xl font-semibold mb-4">Cart Items (<?php echo $cartCount; ?>)</h2>
                    <div class="space-y-4">
                        <?php foreach ($cartItems as $item): ?>
                            <div class="flex items-center space-x-4 border-b pb-4">
                                <div class="flex-shrink-0 w-20 h-20 bg-gray-200 rounded-md overflow-hidden">
                                    <?php if ($item['images']): ?>
                                        <img src="<?php echo htmlspecialchars($item['images']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"
                                             class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <div class="w-full h-full bg-gray-300 flex items-center justify-center">
                                            <svg class="w-8 h-8 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1">
                                    <h3 class="text-lg font-medium text-gray-900">
                                        <a href="<?php echo BASE_URL; ?>/shop/products/<?php echo $item['slug']; ?>" class="hover:text-indigo-600">
                                            <?php echo htmlspecialchars($item['name']); ?>
                                        </a>
                                    </h3>
                                    <p class="text-gray-600">$<?php echo number_format($item['price'], 2); ?> each</p>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <form action="<?php echo BASE_URL; ?>/shop/cart/update" method="POST" class="flex items-center">
                                        <?php echo csrf_token(); ?>
                                        <input type="hidden" name="item_id" value="<?php echo $item['id']; ?>">
                                        <button type="submit" name="quantity" value="<?php echo max(1, $item['quantity'] - 1); ?>"
                                                class="bg-gray-200 text-gray-600 px-2 py-1 rounded-l hover:bg-gray-300">-</button>
                                        <span class="bg-gray-100 px-3 py-1"><?php echo $item['quantity']; ?></span>
                                        <button type="submit" name="quantity" value="<?php echo $item['quantity'] + 1; ?>"
                                                class="bg-gray-200 text-gray-600 px-2 py-1 rounded-r hover:bg-gray-300">+</button>
                                    </form>
                                    <form action="<?php echo BASE_URL; ?>/shop/cart/remove/<?php echo $item['id']; ?>" method="POST" class="ml-4">
                                        <?php echo csrf_token(); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-800">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                                <div class="text-right">
                                    <p class="text-lg font-semibold text-gray-900">$<?php echo number_format($item['total_price'], 2); ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-6 flex justify-between">
                        <a href="<?php echo BASE_URL; ?>/shop/cart/clear" class="text-red-600 hover:text-red-800">
                            Clear Cart
                        </a>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="lg:col-span-1">
                <div class="bg-white shadow rounded-lg p-6 sticky top-6">
                    <h2 class="text-xl font-semibold mb-4">Order Summary</h2>
                    <div class="space-y-2 mb-4">
                        <div class="flex justify-between">
                            <span>Subtotal</span>
                            <span>$<?php echo number_format($subtotal, 2); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span>Tax</span>
                            <span>$<?php echo number_format($tax, 2); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span>Shipping</span>
                            <span><?php echo $shipping > 0 ? '$' . number_format($shipping, 2) : 'FREE'; ?></span>
                        </div>
                        <hr class="my-2">
                        <div class="flex justify-between text-lg font-semibold">
                            <span>Total</span>
                            <span>$<?php echo number_format($total, 2); ?></span>
                        </div>
                    </div>
                    <a href="<?php echo BASE_URL; ?>/shop/checkout"
                       class="w-full bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700 text-center block">
                        Proceed to Checkout
                    </a>
                    <p class="text-xs text-gray-600 mt-2 text-center">
                        Secure checkout powered by our payment system
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
