<?php
/**
 * Service Detail View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <!-- Breadcrumbs -->
    <nav class="flex mb-8" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?php echo BASE_URL; ?>" class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-indigo-600">
                    <svg class="w-3 h-3 mr-2.5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2A1 1 0 0 1 1 10h2v6a3 3 0 0 0 3 3h2a1 1 0 0 0 1-1v-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 0 1 1h2a3 3 0 0 0 3-3v-6h2a1 1 0 0 1 .707-.293Z"/>
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 text-gray-400 mx-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m9 5 7 7-7 7"></path>
                    </svg>
                    <a href="<?php echo BASE_URL; ?>/services" class="text-sm font-medium text-gray-700 hover:text-indigo-600">Services</a>
                </div>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-3 h-3 text-gray-400 mx-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m9 5 7 7-7 7"></path>
                    </svg>
                    <span class="text-sm font-medium text-gray-500"><?php echo htmlspecialchars($service['name']); ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">
        <!-- Service Images -->
        <div class="space-y-4">
            <?php if (!empty($images ?? [])): ?>
                <!-- Main Image -->
                <div class="aspect-w-16 aspect-h-12 bg-gray-200 rounded-lg overflow-hidden">
                    <img id="main-image" src="<?php echo htmlspecialchars($images[0]); ?>" alt="<?php echo htmlspecialchars($service['name']); ?>"
                         class="w-full h-full object-cover">
                </div>
                <!-- Thumbnail Images -->
                <?php if (count($images) > 1): ?>
                    <div class="grid grid-cols-4 gap-2">
                        <?php foreach ($images as $index => $image): ?>
                            <button onclick="changeImage('<?php echo htmlspecialchars($image); ?>')"
                                    class="aspect-w-1 aspect-h-1 bg-gray-200 rounded-lg overflow-hidden border-2 <?php echo $index === 0 ? 'border-indigo-500' : 'border-gray-200'; ?>">
                                <img src="<?php echo htmlspecialchars($image); ?>" alt="Service image <?php echo $index + 1; ?>"
                                     class="w-full h-full object-cover">
                            </button>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="aspect-w-16 aspect-h-12 bg-gradient-to-br from-indigo-100 to-purple-100 rounded-lg flex items-center justify-center">
                    <svg class="w-24 h-24 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                    </svg>
                </div>
            <?php endif; ?>
        </div>

        <!-- Service Information -->
        <div class="space-y-6">
            <div>
                <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo htmlspecialchars($service['name']); ?></h1>
                <div class="flex items-center space-x-4 mb-4">
                    <span class="text-3xl font-bold text-indigo-600">$<?php echo number_format($service['price'], 2); ?></span>
                    <span class="text-gray-600">•</span>
                    <span class="text-gray-600"><?php echo $service['duration_minutes']; ?> minutes</span>
                    <span class="text-gray-600">•</span>
                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                        Available
                    </span>
                </div>
            </div>

            <!-- Quick Book -->
            <div class="bg-indigo-50 border border-indigo-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Book This Service</h3>
                <a href="<?php echo BASE_URL; ?>/book?service=<?php echo $service['id']; ?>" class="w-full bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700 text-center block font-medium">
                    <i class="fas fa-calendar-check mr-2"></i>
                    Book Appointment
                </a>
                <p class="text-sm text-gray-600 mt-2 text-center">
                    Select date, time, and stylist
                </p>
            </div>

            <!-- Service Description -->
            <?php if ($service['description']): ?>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">About This Service</h3>
                    <div class="prose max-w-none text-gray-700">
                        <?php echo nl2br(htmlspecialchars($service['description'])); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Service Details -->
            <div class="bg-gray-50 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Service Details</h3>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Duration:</span>
                        <span class="font-medium"><?php echo $service['duration_minutes']; ?> minutes</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Price:</span>
                        <span class="font-medium">$<?php echo number_format($service['price'], 2); ?></span>
                    </div>
                    <?php if (isset($service['preparation_time'])): ?>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Prep Time:</span>
                            <span class="font-medium"><?php echo $service['preparation_time']; ?> minutes</span>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($service['cleanup_time'])): ?>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Cleanup Time:</span>
                            <span class="font-medium"><?php echo $service['cleanup_time']; ?> minutes</span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- What's Included -->
            <?php if (!empty($features ?? [])): ?>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">What's Included</h3>
                    <ul class="space-y-2">
                        <?php foreach ($features as $feature): ?>
                            <li class="flex items-center text-gray-700">
                                <i class="fas fa-check text-green-500 mr-3"></i>
                                <?php echo htmlspecialchars($feature); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <!-- Before & After Care -->
            <?php if ($service['before_care'] || $service['after_care']): ?>
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Care Instructions</h3>
                    <?php if ($service['before_care']): ?>
                        <div class="mb-4">
                            <h4 class="font-medium text-blue-900 mb-2">Before Your Appointment</h4>
                            <div class="text-blue-800 text-sm">
                                <?php echo nl2br(htmlspecialchars($service['before_care'])); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($service['after_care']): ?>
                        <div>
                            <h4 class="font-medium text-blue-900 mb-2">After Your Appointment</h4>
                            <div class="text-blue-800 text-sm">
                                <?php echo nl2br(htmlspecialchars($service['after_care'])); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Related Services -->
    <?php if (!empty($relatedServices ?? [])): ?>
        <div class="mt-16">
            <h2 class="text-2xl font-bold text-gray-900 mb-8">You Might Also Like</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($relatedServices as $related): ?>
                    <div class="bg-white shadow rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                        <div class="aspect-w-16 aspect-h-12 bg-gray-200">
                            <?php if ($related['images']): ?>
                                <img src="<?php echo htmlspecialchars($related['images']); ?>" alt="<?php echo htmlspecialchars($related['name']); ?>"
                                     class="w-full h-32 object-cover">
                            <?php else: ?>
                                <div class="w-full h-32 bg-gradient-to-br from-indigo-100 to-purple-100 flex items-center justify-center">
                                    <svg class="w-12 h-12 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                                <a href="<?php echo BASE_URL; ?>/services/<?php echo $related['slug']; ?>" class="hover:text-indigo-600">
                                    <?php echo htmlspecialchars($related['name']); ?>
                                </a>
                            </h3>
                            <p class="text-gray-600 text-sm mb-3"><?php echo htmlspecialchars(substr($related['description'], 0, 100)); ?>...</p>
                            <div class="flex justify-between items-center">
                                <span class="text-xl font-bold text-gray-900">$<?php echo number_format($related['price'], 2); ?></span>
                                <a href="<?php echo BASE_URL; ?>/book?service=<?php echo $related['id']; ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 text-sm">
                                    Book Now
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- FAQ Section -->
    <div class="mt-16 bg-gray-50 rounded-lg p-8">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">Frequently Asked Questions</h2>
        <div class="space-y-4">
            <details class="bg-white rounded-lg p-6">
                <summary class="cursor-pointer font-semibold text-gray-900 flex justify-between items-center">
                    How long does the appointment take?
                    <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </summary>
                <p class="mt-4 text-gray-600">
                    This service typically takes <?php echo $service['duration_minutes']; ?> minutes, but please allow extra time for consultation and any preparation that may be needed.
                </p>
            </details>

            <details class="bg-white rounded-lg p-6">
                <summary class="cursor-pointer font-semibold text-gray-900 flex justify-between items-center">
                    Do I need to prepare anything before my appointment?
                    <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </summary>
                <p class="mt-4 text-gray-600">
                    <?php echo $service['before_care'] ?: 'Please arrive 10-15 minutes early for your first appointment. For specific preparation instructions, our staff will contact you before your appointment.'; ?>
                </p>
            </details>

            <details class="bg-white rounded-lg p-6">
                <summary class="cursor-pointer font-semibold text-gray-900 flex justify-between items-center">
                    Can I cancel or reschedule my appointment?
                    <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </summary>
                <p class="mt-4 text-gray-600">
                    Yes, you can cancel or reschedule your appointment through your account dashboard or by calling us directly. Please give us at least 24 hours notice to avoid any cancellation fees.
                </p>
            </details>

            <details class="bg-white rounded-lg p-6">
                <summary class="cursor-pointer font-semibold text-gray-900 flex justify-between items-center">
                    Is there parking available?
                    <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </summary>
                <p class="mt-4 text-gray-600">
                    Yes, we offer complimentary parking for all our clients. Our location has dedicated parking spaces available on-site.
                </p>
            </details>
        </div>
    </div>
</div>

<script>
function changeImage(imageSrc) {
    document.getElementById('main-image').src = imageSrc;

    // Update thumbnail borders
    const thumbnails = document.querySelectorAll('[onclick^="changeImage"]');
    thumbnails.forEach(thumb => {
        thumb.classList.remove('border-indigo-500');
        thumb.classList.add('border-gray-200');
    });

    event.target.closest('button').classList.remove('border-gray-200');
    event.target.closest('button').classList.add('border-indigo-500');
}
</script>
