<?php
/**
 * Staff Layout Template
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo htmlspecialchars($metaDescription ?? 'Staff Dashboard - Luxury Beauty Spa'); ?>">
    <meta name="keywords" content="salon, spa, beauty, staff, dashboard, schedule">
    <title><?php echo htmlspecialchars($pageTitle ?? 'Staff Dashboard'); ?> - Luxury Beauty Spa</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo BASE_URL; ?>/assets/images/favicon.ico">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <link href="<?php echo BASE_URL; ?>/assets/css/admin.css" rel="stylesheet">

    <!-- Additional CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 font-sans">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="w-64 bg-indigo-800 shadow-lg">
            <div class="flex flex-col h-full">
                <!-- Logo -->
                <div class="flex items-center justify-center h-16 bg-indigo-900">
                    <span class="text-white text-xl font-bold">Staff Portal</span>
                </div>

                <!-- Navigation -->
                <nav class="flex-1 px-4 py-6 space-y-2">
                    <a href="<?php echo BASE_URL; ?>/staff" class="nav-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>">
                        <i class="fas fa-tachometer-alt mr-3"></i>
                        Dashboard
                    </a>

                    <div class="border-t border-indigo-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/staff/schedule" class="nav-link <?php echo $currentPage === 'schedule' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-alt mr-3"></i>
                        My Schedule
                    </a>

                    <a href="<?php echo BASE_URL; ?>/staff/bookings" class="nav-link <?php echo $currentPage === 'bookings' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-check mr-3"></i>
                        My Bookings
                    </a>

                    <div class="border-t border-indigo-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/staff/performance" class="nav-link <?php echo $currentPage === 'performance' ? 'active' : ''; ?>">
                        <i class="fas fa-chart-line mr-3"></i>
                        Performance
                    </a>

                    <a href="<?php echo BASE_URL; ?>/staff/profile" class="nav-link <?php echo $currentPage === 'profile' ? 'active' : ''; ?>">
                        <i class="fas fa-user mr-3"></i>
                        Profile
                    </a>

                    <div class="border-t border-indigo-700 my-4"></div>

                    <a href="<?php echo BASE_URL; ?>/logout" class="nav-link text-red-400 hover:text-red-300">
                        <i class="fas fa-sign-out-alt mr-3"></i>
                        Logout
                    </a>
                </nav>

                <!-- Quick Attendance -->
                <div class="px-4 pb-6">
                    <div class="bg-indigo-700 rounded-lg p-4">
                        <h3 class="text-white font-medium mb-3">Quick Attendance</h3>
                        <div class="space-y-2">
                            <button id="clock-in-btn" onclick="clockIn()" class="w-full bg-green-600 text-white px-3 py-2 rounded text-sm hover:bg-green-700 hidden">
                                <i class="fas fa-play mr-2"></i>Clock In
                            </button>
                            <button id="clock-out-btn" onclick="clockOut()" class="w-full bg-red-600 text-white px-3 py-2 rounded text-sm hover:bg-red-700 hidden">
                                <i class="fas fa-stop mr-2"></i>Clock Out
                            </button>
                            <div id="attendance-status" class="text-white text-sm text-center">
                                Loading...
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Bar -->
            <header class="bg-white shadow-sm border-b border-gray-200">
                <div class="px-6 py-4 flex justify-between items-center">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()" class="text-gray-500 hover:text-gray-700 md:hidden">
                            <i class="fas fa-bars"></i>
                        </button>
                        <h1 class="ml-4 text-2xl font-semibold text-gray-900"><?php echo htmlspecialchars($pageTitle ?? 'Dashboard'); ?></h1>
                    </div>

                    <div class="flex items-center space-x-4">
                        <!-- Today's Date -->
                        <div class="text-sm text-gray-600">
                            <?php echo date('l, F j, Y'); ?>
                        </div>

                        <!-- User Menu -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="flex items-center space-x-2 text-gray-700 hover:text-gray-900">
                                <div class="w-8 h-8 bg-indigo-500 rounded-full flex items-center justify-center">
                                    <span class="text-white text-sm font-medium">
                                        <?php echo strtoupper(substr($this->auth->firstName(), 0, 1) . substr($this->auth->lastName(), 0, 1)); ?>
                                    </span>
                                </div>
                                <span class="hidden md:block"><?php echo htmlspecialchars($this->auth->firstName()); ?></span>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </button>

                            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg z-50">
                                <div class="py-1">
                                    <a href="<?php echo BASE_URL; ?>/staff/profile" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-user mr-2"></i>My Profile
                                    </a>
                                    <a href="<?php echo BASE_URL; ?>/staff/schedule/availability" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-calendar mr-2"></i>My Availability
                                    </a>
                                    <div class="border-t border-gray-100"></div>
                                    <a href="<?php echo BASE_URL; ?>/logout" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                                        <i class="fas fa-sign-out-alt mr-2"></i>Logout
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto bg-gray-100 p-6">
                <?php echo $content; ?>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.w-64');
            sidebar.classList.toggle('hidden');
        }

        // Load attendance status on page load
        document.addEventListener('DOMContentLoaded', function() {
            loadAttendanceStatus();
        });

        function loadAttendanceStatus() {
            fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance-status')
                .then(response => response.json())
                .then(data => {
                    const status = data.status;
                    const statusDiv = document.getElementById('attendance-status');
                    const clockInBtn = document.getElementById('clock-in-btn');
                    const clockOutBtn = document.getElementById('clock-out-btn');

                    if (status.is_clocked_in) {
                        statusDiv.innerHTML = `Clocked in at ${status.clock_in_time}`;
                        clockOutBtn.classList.remove('hidden');
                        clockInBtn.classList.add('hidden');
                    } else if (status.can_clock_in) {
                        statusDiv.innerHTML = 'Not clocked in today';
                        clockInBtn.classList.remove('hidden');
                        clockOutBtn.classList.add('hidden');
                    } else {
                        statusDiv.innerHTML = 'Attendance completed';
                        clockInBtn.classList.add('hidden');
                        clockOutBtn.classList.add('hidden');
                    }
                })
                .catch(error => {
                    console.error('Error loading attendance status:', error);
                });
        }

        function clockIn() {
            fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'action=clock_in&csrf_token=<?php echo csrf_token(); ?>'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadAttendanceStatus();
                } else {
                    alert(data.message || 'Failed to clock in');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to clock in');
            });
        }

        function clockOut() {
            fetch('<?php echo BASE_URL; ?>/staff/dashboard/attendance', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'action=clock_out&csrf_token=<?php echo csrf_token(); ?>'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadAttendanceStatus();
                } else {
                    alert(data.message || 'Failed to clock out');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to clock out');
            });
        }
    </script>

    <!-- Custom JavaScript -->
    <script src="<?php echo BASE_URL; ?>/assets/js/admin.js"></script>
</body>
</html>
