<?php
/**
 * Public Layout Template
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo htmlspecialchars($metaDescription ?? 'Luxury Beauty Spa - Professional salon services with expert stylists. Book your appointment online today.'); ?>">
    <meta name="keywords" content="salon, spa, beauty, hair styling, massage, facial, manicure, pedicure, luxury, professional">

    <!-- SEO Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($pageTitle ?? 'Luxury Beauty Spa'); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($metaDescription ?? 'Luxury Beauty Spa - Professional salon services with expert stylists. Book your appointment online today.'); ?>">
    <meta property="og:image" content="<?php echo BASE_URL; ?>/assets/images/og-image.jpg">
    <meta property="og:url" content="<?php echo BASE_URL . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:type" content="website">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($pageTitle ?? 'Luxury Beauty Spa'); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($metaDescription ?? 'Luxury Beauty Spa - Professional salon services with expert stylists. Book your appointment online today.'); ?>">
    <meta name="twitter:image" content="<?php echo BASE_URL; ?>/assets/images/twitter-image.jpg">

    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo BASE_URL . $_SERVER['REQUEST_URI']; ?>">

    <title><?php echo htmlspecialchars($pageTitle ?? 'Luxury Beauty Spa'); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo BASE_URL; ?>/assets/images/favicon.ico">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <link href="<?php echo BASE_URL; ?>/assets/css/style.css" rel="stylesheet">

    <!-- Additional CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo BASE_URL; ?>/manifest.json">

    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "BeautySalon",
        "name": "Luxury Beauty Spa",
        "description": "Professional salon services with expert stylists",
        "url": "<?php echo BASE_URL; ?>",
        "telephone": "+1-555-0123",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "123 Beauty Street",
            "addressLocality": "New York",
            "addressRegion": "NY",
            "postalCode": "10001",
            "addressCountry": "US"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": 40.7128,
            "longitude": -74.0060
        },
        "openingHours": [
            "Mo-Sa 09:00-18:00",
            "Su 10:00-16:00"
        ],
        "priceRange": "$$"
    }
    </script>
</head>
<body class="font-['Inter'] text-gray-900 bg-white">
    <!-- Top Bar -->
    <div class="bg-gray-900 text-white text-sm py-2">
        <div class="container mx-auto px-4 flex justify-between items-center">
            <div class="flex items-center space-x-6">
                <div class="flex items-center">
                    <i class="fas fa-map-marker-alt mr-2"></i>
                    <span>123 Beauty Street, New York, NY</span>
                </div>
                <div class="flex items-center">
                    <i class="fas fa-clock mr-2"></i>
                    <span>Open: Mon-Sat 9AM-6PM, Sun 10AM-4PM</span>
                </div>
            </div>
            <div class="flex items-center space-x-4">
                <a href="tel:+15550123" class="hover:text-gray-300">
                    <i class="fas fa-phone mr-1"></i> +1 (555) 012-3456
                </a>
                <div class="flex space-x-3">
                    <a href="#" class="hover:text-gray-300"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="hover:text-gray-300"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="hover:text-gray-300"><i class="fab fa-twitter"></i></a>
                </div>
            </div>
        </div>
    </div>

    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="<?php echo BASE_URL; ?>" class="text-2xl font-bold text-gray-900">
                        Luxury Beauty Spa
                    </a>
                </div>

                <!-- Desktop Navigation -->
                <nav class="hidden md:flex space-x-8">
                    <a href="<?php echo BASE_URL; ?>" class="text-gray-700 hover:text-indigo-600 font-medium">Home</a>
                    <a href="<?php echo BASE_URL; ?>/services" class="text-gray-700 hover:text-indigo-600 font-medium">Services</a>
                    <a href="<?php echo BASE_URL; ?>/about" class="text-gray-700 hover:text-indigo-600 font-medium">About</a>
                    <a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-700 hover:text-indigo-600 font-medium">Gallery</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-gray-700 hover:text-indigo-600 font-medium">Contact</a>
                    <a href="<?php echo BASE_URL; ?>/shop" class="text-gray-700 hover:text-indigo-600 font-medium">Shop</a>
                </nav>

                <!-- Right Side Actions -->
                <div class="flex items-center space-x-4">
                    <!-- Account -->
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="text-gray-700 hover:text-indigo-600">
                            <i class="fas fa-user"></i>
                        </button>
                        <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg z-50">
                            <div class="py-1">
                                <?php if ($this->auth->check()): ?>
                                    <a href="<?php echo BASE_URL; ?>/profile" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        My Profile
                                    </a>
                                    <a href="<?php echo BASE_URL; ?>/bookings" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        My Bookings
                                    </a>
                                    <div class="border-t border-gray-100"></div>
                                    <a href="<?php echo BASE_URL; ?>/logout" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                                        Logout
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo BASE_URL; ?>/login" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        Login
                                    </a>
                                    <a href="<?php echo BASE_URL; ?>/register" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        Register
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Book Now Button -->
                    <a href="<?php echo BASE_URL; ?>/book" class="bg-indigo-600 text-white px-6 py-2 rounded-full hover:bg-indigo-700 font-medium hidden md:inline-block">
                        Book Now
                    </a>

                    <!-- Call Button -->
                    <a href="tel:+15550123" class="text-gray-700 hover:text-indigo-600">
                        <i class="fas fa-phone"></i>
                    </a>

                    <!-- Mobile Menu Button -->
                    <button onclick="toggleMobileMenu()" class="md:hidden text-gray-700">
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
            </div>

            <!-- Mobile Navigation -->
            <div id="mobile-menu" class="md:hidden hidden pb-4">
                <nav class="flex flex-col space-y-4">
                    <a href="<?php echo BASE_URL; ?>" class="text-gray-700 hover:text-indigo-600 font-medium">Home</a>
                    <a href="<?php echo BASE_URL; ?>/services" class="text-gray-700 hover:text-indigo-600 font-medium">Services</a>
                    <a href="<?php echo BASE_URL; ?>/about" class="text-gray-700 hover:text-indigo-600 font-medium">About</a>
                    <a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-700 hover:text-indigo-600 font-medium">Gallery</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-gray-700 hover:text-indigo-600 font-medium">Contact</a>
                    <a href="<?php echo BASE_URL; ?>/shop" class="text-gray-700 hover:text-indigo-600 font-medium">Shop</a>
                    <a href="<?php echo BASE_URL; ?>/book" class="bg-indigo-600 text-white px-4 py-2 rounded-md text-center">Book Now</a>
                </nav>
            </div>
        </div>
    </header>

    <!-- Mobile Bottom Navigation -->
    <nav class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 z-40">
        <div class="grid grid-cols-5 gap-1 py-2">
            <a href="<?php echo BASE_URL; ?>" class="flex flex-col items-center py-2 text-xs <?php echo $currentPage === 'home' ? 'text-indigo-600' : 'text-gray-600'; ?>">
                <i class="fas fa-home mb-1"></i>
                <span>Home</span>
            </a>
            <a href="<?php echo BASE_URL; ?>/services" class="flex flex-col items-center py-2 text-xs <?php echo $currentPage === 'services' ? 'text-indigo-600' : 'text-gray-600'; ?>">
                <i class="fas fa-concierge-bell mb-1"></i>
                <span>Services</span>
            </a>
            <a href="<?php echo BASE_URL; ?>/book" class="flex flex-col items-center py-2 text-xs bg-indigo-600 text-white rounded-full -mt-4 mx-2 shadow-lg">
                <i class="fas fa-plus mb-1"></i>
                <span>Book</span>
            </a>
            <a href="<?php echo BASE_URL; ?>/shop" class="flex flex-col items-center py-2 text-xs <?php echo $currentPage === 'shop' ? 'text-indigo-600' : 'text-gray-600'; ?>">
                <i class="fas fa-shopping-bag mb-1"></i>
                <span>Shop</span>
            </a>
            <a href="<?php echo $this->auth->check() ? BASE_URL . '/profile' : BASE_URL . '/login'; ?>" class="flex flex-col items-center py-2 text-xs <?php echo $currentPage === 'profile' ? 'text-indigo-600' : 'text-gray-600'; ?>">
                <i class="fas fa-user mb-1"></i>
                <span>Profile</span>
            </a>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="min-h-screen <?php echo $currentPage === 'home' ? '' : 'pt-8 pb-20 md:pb-8'; ?>">
        <?php echo $content; ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white">
        <div class="container mx-auto px-4 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div>
                    <h3 class="text-xl font-bold mb-4">Luxury Beauty Spa</h3>
                    <p class="text-gray-300 mb-4">
                        Professional salon services with expert stylists. Experience luxury and beauty in one place.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-300 hover:text-white"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="text-gray-300 hover:text-white"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="text-gray-300 hover:text-white"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-gray-300 hover:text-white"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h4 class="text-lg font-semibold mb-4">Quick Links</h4>
                    <ul class="space-y-2">
                        <li><a href="<?php echo BASE_URL; ?>" class="text-gray-300 hover:text-white">Home</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/services" class="text-gray-300 hover:text-white">Services</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/about" class="text-gray-300 hover:text-white">About Us</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-300 hover:text-white">Gallery</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/contact" class="text-gray-300 hover:text-white">Contact</a></li>
                    </ul>
                </div>

                <!-- Services -->
                <div>
                    <h4 class="text-lg font-semibold mb-4">Services</h4>
                    <ul class="space-y-2">
                        <li><a href="<?php echo BASE_URL; ?>/services/hair-styling" class="text-gray-300 hover:text-white">Hair Styling</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/services/massage" class="text-gray-300 hover:text-white">Massage</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/services/facial" class="text-gray-300 hover:text-white">Facial Treatments</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/services/manicure" class="text-gray-300 hover:text-white">Manicure & Pedicure</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/services/makeup" class="text-gray-300 hover:text-white">Makeup</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div>
                    <h4 class="text-lg font-semibold mb-4">Contact Info</h4>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <i class="fas fa-map-marker-alt mr-3 text-indigo-400"></i>
                            <span class="text-gray-300">123 Beauty Street<br>New York, NY 10001</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-phone mr-3 text-indigo-400"></i>
                            <a href="tel:+15550123" class="text-gray-300 hover:text-white">+1 (555) 012-3456</a>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-envelope mr-3 text-indigo-400"></i>
                            <a href="mailto:info@luxurybeautyspa.com" class="text-gray-300 hover:text-white">info@luxurybeautyspa.com</a>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-clock mr-3 text-indigo-400"></i>
                            <span class="text-gray-300">Mon-Sat: 9AM-6PM<br>Sun: 10AM-4PM</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Newsletter Signup -->
            <div class="border-t border-gray-700 mt-8 pt-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-4 md:mb-0">
                        <h4 class="text-lg font-semibold mb-2">Stay Updated</h4>
                        <p class="text-gray-300">Subscribe to our newsletter for the latest beauty tips and exclusive offers.</p>
                    </div>
                    <div class="flex w-full md:w-auto">
                        <input type="email" placeholder="Enter your email" class="px-4 py-2 rounded-l-md border-0 flex-1 md:w-64">
                        <button class="bg-indigo-600 text-white px-6 py-2 rounded-r-md hover:bg-indigo-700">
                            Subscribe
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Bar -->
        <div class="border-t border-gray-700">
            <div class="container mx-auto px-4 py-4">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <p class="text-gray-400 text-sm">
                        © <?php echo date('Y'); ?> Luxury Beauty Spa. All rights reserved.
                    </p>
                    <div class="flex space-x-6 mt-2 md:mt-0">
                        <a href="<?php echo BASE_URL; ?>/privacy" class="text-gray-400 hover:text-white text-sm">Privacy Policy</a>
                        <a href="<?php echo BASE_URL; ?>/terms" class="text-gray-400 hover:text-white text-sm">Terms of Service</a>
                        <a href="<?php echo BASE_URL; ?>/sitemap" class="text-gray-400 hover:text-white text-sm">Sitemap</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

    <!-- PWA Service Worker -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('<?php echo BASE_URL; ?>/sw.js');
            });
        }
    </script>

    <!-- Custom JavaScript -->
    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>

    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }
    </script>
</body>
</html>
