<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Premium beauty and wellness services. Book your appointment online with our expert stylists and therapists.">
    <meta name="keywords" content="salon, spa, beauty, hair styling, massage, facial, manicure">
    <meta name="author" content="Salon System">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Luxury Beauty Spa - Premium Salon Services">
    <meta property="og:description" content="Experience luxury beauty treatments at our premium salon. Book online today.">
    <meta property="og:image" content="<?php echo ASSETS_URL; ?>/images/og-image.jpg">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Luxury Beauty Spa - Premium Salon Services">
    <meta name="twitter:description" content="Experience luxury beauty treatments at our premium salon. Book online today.">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo ASSETS_URL; ?>/images/favicon.ico">
    <link rel="apple-touch-icon" href="<?php echo ASSETS_URL; ?>/images/apple-touch-icon.png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <link href="<?php echo ASSETS_URL; ?>/css/tailwind.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="<?php echo ASSETS_URL; ?>/css/style.css" rel="stylesheet">

    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>Luxury Beauty Spa</title>

    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo BASE_URL; ?>/manifest.json">

    <!-- Schema.org JSON-LD -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "BeautySalon",
        "name": "Luxury Beauty Spa",
        "description": "Premium beauty and wellness services",
        "url": "<?php echo BASE_URL; ?>",
        "telephone": "+1234567890",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "123 Beauty Street",
            "addressLocality": "Wellness City",
            "addressRegion": "NY",
            "postalCode": "12345",
            "addressCountry": "US"
        },
        "openingHours": [
            "Mo-Fr 09:00-19:00",
            "Sa 08:00-18:00",
            "Su 10:00-16:00"
        ],
        "priceRange": "$$"
    }
    </script>
</head>
<body class="font-['Inter'] text-gray-900 bg-white">
    <!-- Top Bar -->
    <div class="bg-gray-900 text-white py-2">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center text-sm">
                <!-- Location -->
                <div class="flex items-center space-x-2">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"/>
                    </svg>
                    <span>Downtown Salon - 123 Beauty Street</span>
                </div>

                <!-- Opening Hours -->
                <div class="hidden md:flex items-center space-x-2">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                    </svg>
                    <span>Open Today: 9:00 AM - 7:00 PM</span>
                </div>

                <!-- Contact & Social -->
                <div class="flex items-center space-x-4">
                    <a href="tel:+1234567890" class="flex items-center space-x-1 hover:text-amber-400 transition-colors">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                        </svg>
                        <span class="hidden sm:inline">+1 (234) 567-8900</span>
                    </a>

                    <div class="flex space-x-2">
                        <a href="#" class="hover:text-amber-400 transition-colors">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/>
                            </svg>
                        </a>
                        <a href="#" class="hover:text-amber-400 transition-colors">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.749.097.118.112.221.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.747-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24c6.624 0 11.99-5.367 11.99-11.987C24.007 5.367 18.641.001.012.017z"/>
                            </svg>
                        </a>
                        <a href="#" class="hover:text-amber-400 transition-colors">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 6.62 5.367 11.987 11.988 11.987s11.987-5.367 11.987-11.987C24.004 5.367 18.637.001 12.017.001zM8.449 16.988c-1.297 0-2.448-.49-2.448-2.31 0-2.169 1.839-3.918 4.228-3.918 1.077 0 1.982.492 2.527 1.258.494.698.771 1.817.771 3.043 0 .768-.159 1.429-.505 1.973-.346.544-1.026.949-1.812.949-.766 0-1.414-.404-1.812-.949-.346-.479-.505-1.092-.505-1.973 0-.831.185-1.516.494-1.982.371-.544.967-.857 1.594-.857.833 0 1.297.544 1.594.857.371.544.494 1.258.494 1.982 0 .698-.119 1.258-.346 1.673-.227.415-.618.77-1.077.77-.563 0-1.026-.346-1.258-.857-.159-.479-.346-.857-.346-1.403 0-.698.119-1.258.346-1.673.227-.415.618-.77 1.077-.77.563 0 1.026.346 1.258.857.159.479.346.857.346 1.403 0 .698-.119 1.258-.346 1.673-.227.415-.618.77-1.077.77-.563 0-1.026-.346-1.258-.857-.159-.479-.346-.857-.346-1.403 0-.698.119-1.258.346-1.673.227-.415.618-.77 1.077-.77z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="<?php echo BASE_URL; ?>" class="flex items-center space-x-2">
                        <img src="<?php echo ASSETS_URL; ?>/images/logo.png" alt="Luxury Beauty Spa" class="h-10 w-auto" onerror="this.src='<?php echo ASSETS_URL; ?>/images/logo-placeholder.png'">
                        <span class="text-xl font-bold text-gray-900">Luxury Beauty Spa</span>
                    </a>
                </div>

                <!-- Desktop Navigation -->
                <nav class="hidden md:flex space-x-8">
                    <a href="<?php echo BASE_URL; ?>" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Home</a>
                    <a href="<?php echo BASE_URL; ?>/services" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Services</a>
                    <a href="<?php echo BASE_URL; ?>/about" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">About</a>
                    <a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Gallery</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Contact</a>
                </nav>

                <!-- Right Side Actions -->
                <div class="flex items-center space-x-4">
                    <!-- Account/Login -->
                    <?php if ($auth && $auth->check()): ?>
                        <div class="relative group">
                            <button class="flex items-center space-x-2 text-gray-700 hover:text-amber-600 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                <span><?php echo htmlspecialchars($user['first_name']); ?></span>
                            </button>
                            <div class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200">
                                <a href="<?php echo BASE_URL; ?>/dashboard" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                                <a href="<?php echo BASE_URL; ?>/profile" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profile</a>
                                <a href="<?php echo BASE_URL; ?>/bookings" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">My Bookings</a>
                                <div class="border-t border-gray-100"></div>
                                <a href="<?php echo BASE_URL; ?>/logout" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Logout</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo BASE_URL; ?>/login" class="text-gray-700 hover:text-amber-600 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Login
                        </a>
                    <?php endif; ?>

                    <!-- Book Now Button -->
                    <a href="<?php echo BASE_URL; ?>/book" class="bg-amber-600 text-white px-4 py-2 rounded-md text-sm font-medium hover:bg-amber-700 transition-colors">
                        Book Now
                    </a>

                    <!-- Call Button -->
                    <a href="tel:+1234567890" class="hidden sm:flex items-center space-x-2 bg-green-600 text-white px-4 py-2 rounded-md text-sm font-medium hover:bg-green-700 transition-colors">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                        </svg>
                        <span>Call</span>
                    </a>

                    <!-- Mobile menu button -->
                    <button id="mobile-menu-button" class="md:hidden p-2 rounded-md text-gray-700 hover:text-amber-600 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-amber-500">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Mobile Navigation -->
            <div id="mobile-menu" class="md:hidden hidden pb-4 border-t border-gray-200 pt-4">
                <nav class="flex flex-col space-y-2">
                    <a href="<?php echo BASE_URL; ?>" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-base font-medium transition-colors">Home</a>
                    <a href="<?php echo BASE_URL; ?>/services" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-base font-medium transition-colors">Services</a>
                    <a href="<?php echo BASE_URL; ?>/about" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-base font-medium transition-colors">About</a>
                    <a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-base font-medium transition-colors">Gallery</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-base font-medium transition-colors">Contact</a>
                    <div class="border-t border-gray-200 pt-2 mt-2">
                        <a href="tel:+1234567890" class="flex items-center space-x-2 text-green-600 hover:text-green-700 px-3 py-2 text-base font-medium transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                            </svg>
                            <span>Call +1 (234) 567-8900</span>
                        </a>
                    </div>
                </nav>
            </div>
        </div>
    </header>

    <!-- Flash Messages -->
    <?php if ($flashMessage): ?>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-4">
            <div class="bg-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-50 border border-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-200 text-<?php echo $flashMessage['type'] === 'success' ? 'green' : ($flashMessage['type'] === 'warning' ? 'yellow' : 'red'); ?>-800 px-4 py-3 rounded-md">
                <?php echo htmlspecialchars($flashMessage['message']); ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main>
