    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div class="col-span-1 md:col-span-2">
                    <div class="flex items-center space-x-2 mb-4">
                        <img src="<?php echo ASSETS_URL; ?>/images/logo-white.png" alt="Luxury Beauty Spa" class="h-8 w-auto" onerror="this.src='<?php echo ASSETS_URL; ?>/images/logo-placeholder.png'">
                        <span class="text-lg font-bold">Luxury Beauty Spa</span>
                    </div>
                    <p class="text-gray-300 mb-4 max-w-md">
                        Experience luxury beauty treatments with our expert stylists and therapists.
                        We provide premium services in a relaxing and elegant environment.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/>
                            </svg>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 6.62 5.367 11.987 11.988 11.987s11.987-5.367 11.987-11.987C24.004 5.367 18.637.001 12.017.001zM8.449 16.988c-1.297 0-2.448-.49-2.448-2.31 0-2.169 1.839-3.918 4.228-3.918 1.077 0 1.982.492 2.527 1.258.494.698.771 1.817.771 3.043 0 .768-.159 1.429-.505 1.973-.346.544-1.026.949-1.812.949-.766 0-1.414-.404-1.812-.949-.346-.479-.505-1.092-.505-1.973 0-.831.185-1.516.494-1.982.371-.544.967-.857 1.594-.857.833 0 1.297.544 1.594.857.371.544.494 1.258.494 1.982 0 .698-.119 1.258-.346 1.673-.227.415-.618.77-1.077.77-.563 0-1.026-.346-1.258-.857-.159-.479-.346-.857-.346-1.403 0-.698.119-1.258.346-1.673.227-.415.618-.77 1.077-.77.563 0 1.026.346 1.258.857.159.479.346.857.346 1.403 0 .698-.119 1.258-.346 1.673-.227.415-.618.77-1.077.77-.563 0-1.026-.346-1.258-.857-.159-.479-.346-.857-.346-1.403 0-.698.119-1.258.346-1.673.227-.415.618-.77 1.077-.77z"/>
                            </svg>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.749.097.118.112.221.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.747-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24c6.624 0 11.99-5.367 11.99-11.987C24.007 5.367 18.641.001.012.017z"/>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Quick Links</h3>
                    <ul class="space-y-2">
                        <li><a href="<?php echo BASE_URL; ?>/services" class="text-gray-300 hover:text-white transition-colors">Services</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/book" class="text-gray-300 hover:text-white transition-colors">Book Appointment</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/gallery" class="text-gray-300 hover:text-white transition-colors">Gallery</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/about" class="text-gray-300 hover:text-white transition-colors">About Us</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/contact" class="text-gray-300 hover:text-white transition-colors">Contact</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Contact Info</h3>
                    <div class="space-y-3">
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-amber-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <div>
                                <p class="text-gray-300">123 Beauty Street</p>
                                <p class="text-gray-300">Wellness City, NY 12345</p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                            <a href="tel:+1234567890" class="text-gray-300 hover:text-white transition-colors">+1 (234) 567-8900</a>
                        </div>
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <a href="mailto:info@luxurybeautyspa.com" class="text-gray-300 hover:text-white transition-colors">info@luxurybeautyspa.com</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-800 mt-8 pt-8 text-center">
                <p class="text-gray-400">
                    &copy; <?php echo date('Y'); ?> Luxury Beauty Spa. All rights reserved.
                    <span class="mx-2">|</span>
                    <a href="<?php echo BASE_URL; ?>/privacy" class="text-gray-400 hover:text-white transition-colors">Privacy Policy</a>
                    <span class="mx-2">|</span>
                    <a href="<?php echo BASE_URL; ?>/terms" class="text-gray-400 hover:text-white transition-colors">Terms of Service</a>
                </p>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script src="<?php echo ASSETS_URL; ?>/js/app.js"></script>

    <!-- PWA Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('SW registered: ', registration);
                    })
                    .catch(function(registrationError) {
                        console.log('SW registration failed: ', registrationError);
                    });
            });
        }
    </script>
</body>
</html>
