<?php
/**
 * Homepage View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<!-- Hero Section -->
<section class="relative bg-gradient-to-br from-indigo-900 via-purple-900 to-pink-900 text-white">
    <div class="absolute inset-0 bg-black opacity-30"></div>
    <div class="relative container mx-auto px-4 py-24 md:py-32">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6 leading-tight">
                Experience Luxury Beauty
                <span class="block text-transparent bg-clip-text bg-gradient-to-r from-pink-400 to-purple-400">
                    Like Never Before
                </span>
            </h1>
            <p class="text-xl md:text-2xl mb-8 text-gray-200 leading-relaxed">
                Professional salon services with expert stylists in a luxurious environment.
                Book your appointment today and discover the difference.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo BASE_URL; ?>/book" class="bg-gradient-to-r from-pink-500 to-purple-600 text-white px-8 py-4 rounded-full text-lg font-semibold hover:from-pink-600 hover:to-purple-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                    <i class="fas fa-calendar-check mr-2"></i>
                    Book Appointment
                </a>
                <a href="<?php echo BASE_URL; ?>/services" class="bg-white text-gray-900 px-8 py-4 rounded-full text-lg font-semibold hover:bg-gray-100 transform hover:scale-105 transition-all duration-200 shadow-lg">
                    <i class="fas fa-concierge-bell mr-2"></i>
                    View Services
                </a>
            </div>
        </div>
    </div>

    <!-- Scroll Indicator -->
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
        </svg>
    </div>
</section>

<!-- Services Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Our Services</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Discover our comprehensive range of beauty services designed to enhance your natural beauty
                and leave you feeling confident and rejuvenated.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Hair Services -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/hair-styling.jpg" alt="Hair Styling" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Hair Styling</h3>
                        <p class="text-white/80">Professional cuts, colors & treatments</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Expert hair styling services including cuts, colors, highlights, and specialized treatments for all hair types.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $45</span>
                        <a href="<?php echo BASE_URL; ?>/services/hair-styling" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>

            <!-- Massage -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/massage.jpg" alt="Massage Therapy" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Massage Therapy</h3>
                        <p class="text-white/80">Relaxing therapeutic massages</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Therapeutic massage treatments designed to relieve stress, reduce muscle tension, and promote overall wellness.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $80</span>
                        <a href="<?php echo BASE_URL; ?>/services/massage" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>

            <!-- Facial Treatments -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/facial.jpg" alt="Facial Treatments" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Facial Treatments</h3>
                        <p class="text-white/80">Rejuvenating skin care</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Professional facial treatments using premium products to cleanse, exfoliate, and nourish your skin.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $65</span>
                        <a href="<?php echo BASE_URL; ?>/services/facial" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>

            <!-- Manicure & Pedicure -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/manicure.jpg" alt="Manicure & Pedicure" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Manicure & Pedicure</h3>
                        <p class="text-white/80">Beautiful hands & feet</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Complete nail care services including manicures, pedicures, gel extensions, and nail art.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $25</span>
                        <a href="<?php echo BASE_URL; ?>/services/manicure" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>

            <!-- Makeup -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/makeup.jpg" alt="Makeup Services" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Makeup Services</h3>
                        <p class="text-white/80">Professional makeup application</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Expert makeup services for special occasions, bridal makeup, and everyday looks using premium products.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $55</span>
                        <a href="<?php echo BASE_URL; ?>/services/makeup" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>

            <!-- Waxing -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                <div class="relative">
                    <img src="<?php echo BASE_URL; ?>/assets/images/services/waxing.jpg" alt="Body Waxing" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                    <div class="absolute bottom-4 left-4">
                        <h3 class="text-white text-xl font-bold">Body Waxing</h3>
                        <p class="text-white/80">Smooth, professional waxing</p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-gray-600 mb-4">Professional waxing services for complete hair removal using gentle, effective techniques.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-2xl font-bold text-indigo-600">From $35</span>
                        <a href="<?php echo BASE_URL; ?>/services/waxing" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition-colors">
                            Learn More
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-12">
            <a href="<?php echo BASE_URL; ?>/services" class="bg-indigo-600 text-white px-8 py-4 rounded-full text-lg font-semibold hover:bg-indigo-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                View All Services
            </a>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Why Choose Luxury Beauty Spa</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Experience the difference with our commitment to excellence, professional expertise,
                and dedication to your beauty and wellness journey.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-indigo-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-md text-2xl text-indigo-600"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Expert Stylists</h3>
                <p class="text-gray-600">Our certified professionals bring years of experience and stay updated with the latest techniques.</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-pink-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-spa text-2xl text-pink-600"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Premium Products</h3>
                <p class="text-gray-600">We use only high-quality, salon-grade products that are safe and effective for your skin and hair.</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-clock text-2xl text-green-600"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Convenient Booking</h3>
                <p class="text-gray-600">Easy online booking system with flexible scheduling to fit your busy lifestyle.</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-heart text-2xl text-purple-600"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">Personalized Care</h3>
                <p class="text-gray-600">Every client receives personalized attention and customized treatments for optimal results.</p>
            </div>
        </div>
    </div>
</section>

<!-- Gallery Preview -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Our Work</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                See the beautiful transformations and stunning results from our satisfied clients.
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="group overflow-hidden rounded-lg">
                <img src="<?php echo BASE_URL; ?>/assets/images/gallery/hair-1.jpg" alt="Hair styling work" class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
            </div>
            <div class="group overflow-hidden rounded-lg">
                <img src="<?php echo BASE_URL; ?>/assets/images/gallery/makeup-1.jpg" alt="Makeup work" class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
            </div>
            <div class="group overflow-hidden rounded-lg">
                <img src="<?php echo BASE_URL; ?>/assets/images/gallery/nails-1.jpg" alt="Nail work" class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
            </div>
            <div class="group overflow-hidden rounded-lg">
                <img src="<?php echo BASE_URL; ?>/assets/images/gallery/spa-1.jpg" alt="Spa work" class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.src='<?php echo BASE_URL; ?>/assets/images/placeholder.jpg'">
            </div>
        </div>

        <div class="text-center mt-8">
            <a href="<?php echo BASE_URL; ?>/gallery" class="bg-gray-800 text-white px-8 py-4 rounded-full text-lg font-semibold hover:bg-gray-900 transform hover:scale-105 transition-all duration-200 shadow-lg">
                View Full Gallery
            </a>
        </div>
    </div>
</section>

<!-- Testimonials -->
<section class="py-20 bg-gradient-to-r from-indigo-900 to-purple-900 text-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">What Our Clients Say</h2>
            <p class="text-lg text-indigo-200 max-w-2xl mx-auto">
                Don't just take our word for it. Here's what our satisfied clients have to say about their experience.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-pink-500 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold">SJ</span>
                    </div>
                    <div>
                        <h4 class="font-semibold">Sarah Johnson</h4>
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <p class="text-indigo-100 italic">
                    "Absolutely amazing experience! The staff is incredibly professional and the results exceeded my expectations. Highly recommend!"
                </p>
            </div>

            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold">MC</span>
                    </div>
                    <div>
                        <h4 class="font-semibold">Mike Chen</h4>
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <p class="text-indigo-100 italic">
                    "Best haircut I've ever had! The attention to detail and personalized service made all the difference. Will definitely be back."
                </p>
            </div>

            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-pink-500 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold">ED</span>
                    </div>
                    <div>
                        <h4 class="font-semibold">Emma Davis</h4>
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <p class="text-indigo-100 italic">
                    "The facial treatment was incredible! My skin feels amazing and looks so much better. The products they use are top-notch."
                </p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gray-900 text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">Ready to Transform Your Look?</h2>
        <p class="text-xl text-gray-300 mb-8 max-w-2xl mx-auto">
            Book your appointment today and experience the luxury beauty treatment you deserve.
            Our expert stylists are ready to make you look and feel amazing.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="<?php echo BASE_URL; ?>/book" class="bg-gradient-to-r from-pink-500 to-purple-600 text-white px-8 py-4 rounded-full text-lg font-semibold hover:from-pink-600 hover:to-purple-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                <i class="fas fa-calendar-check mr-2"></i>
                Book Your Appointment
            </a>
            <a href="tel:+15550123" class="bg-white text-gray-900 px-8 py-4 rounded-full text-lg font-semibold hover:bg-gray-100 transform hover:scale-105 transition-all duration-200 shadow-lg">
                <i class="fas fa-phone mr-2"></i>
                Call Now: (555) 012-3456
            </a>
        </div>
    </div>
</section>