<?php
/**
 * 404 Not Found Error Page
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="min-h-screen bg-gray-50 flex flex-col justify-center py-12 sm:px-6 lg:px-8">
    <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
        <div class="bg-white py-8 px-4 shadow-xl rounded-lg sm:px-10 text-center">
            <!-- Error Icon -->
            <div class="mx-auto flex items-center justify-center h-24 w-24 rounded-full bg-red-100 mb-6">
                <svg class="h-12 w-12 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
            </div>

            <!-- Error Message -->
            <h1 class="text-4xl font-bold text-gray-900 mb-2">404</h1>
            <h2 class="text-2xl font-semibold text-gray-700 mb-4">Page Not Found</h2>
            <p class="text-gray-600 mb-8">
                Sorry, we couldn't find the page you're looking for. It might have been moved, deleted, or you entered the wrong URL.
            </p>

            <!-- Actions -->
            <div class="space-y-4">
                <a href="<?php echo BASE_URL; ?>" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-home mr-2"></i>
                    Go to Homepage
                </a>

                <button onclick="history.back()" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Go Back
                </button>

                <a href="<?php echo BASE_URL; ?>/contact" class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <i class="fas fa-envelope mr-2"></i>
                    Contact Support
                </a>
            </div>

            <!-- Search -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <p class="text-sm text-gray-600 mb-4">Or try searching for what you need:</p>
                <div class="flex">
                    <input type="text" placeholder="Search..." class="flex-1 px-3 py-2 border border-gray-300 rounded-l-md focus:outline-none focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500">
                    <button class="px-4 py-2 border border-l-0 border-gray-300 bg-gray-50 rounded-r-md hover:bg-gray-100 focus:outline-none focus:ring-1 focus:ring-indigo-500">
                        <i class="fas fa-search text-gray-600"></i>
                    </button>
                </div>
            </div>

            <!-- Popular Pages -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <p class="text-sm text-gray-600 mb-4">Popular pages:</p>
                <div class="grid grid-cols-2 gap-2 text-sm">
                    <a href="<?php echo BASE_URL; ?>/services" class="text-indigo-600 hover:text-indigo-800">Services</a>
                    <a href="<?php echo BASE_URL; ?>/book" class="text-indigo-600 hover:text-indigo-800">Book Appointment</a>
                    <a href="<?php echo BASE_URL; ?>/shop" class="text-indigo-600 hover:text-indigo-800">Shop</a>
                    <a href="<?php echo BASE_URL; ?>/about" class="text-indigo-600 hover:text-indigo-800">About Us</a>
                    <a href="<?php echo BASE_URL; ?>/gallery" class="text-indigo-600 hover:text-indigo-800">Gallery</a>
                    <a href="<?php echo BASE_URL; ?>/contact" class="text-indigo-600 hover:text-indigo-800">Contact</a>
                </div>
            </div>
        </div>

        <!-- Additional Help -->
        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600">
                If you believe this is an error, please <a href="<?php echo BASE_URL; ?>/contact" class="text-indigo-600 hover:text-indigo-800">contact our support team</a>.
            </p>
        </div>
    </div>
</div>