<?php
/**
 * Admin Settings Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Settings</h1>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['form_errors'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul>
                <?php foreach ($_SESSION['form_errors'] as $error): ?>
                    <li><?php echo htmlspecialchars($error); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php unset($_SESSION['form_errors']); ?>
    <?php endif; ?>

    <form action="<?php echo BASE_URL; ?>/admin/settings/update" method="POST" class="space-y-8">
        <?php echo csrf_token(); ?>

        <!-- Company Settings -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Company Settings</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Company Name</label>
                    <input type="text" name="company_name" value="<?php echo htmlspecialchars($settings['company_name'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" name="company_email" value="<?php echo htmlspecialchars($settings['company_email'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Phone</label>
                    <input type="tel" name="company_phone" value="<?php echo htmlspecialchars($settings['company_phone'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Address</label>
                    <input type="text" name="company_address" value="<?php echo htmlspecialchars($settings['company_address'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea name="company_description" rows="3"
                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($settings['company_description'] ?? ''); ?></textarea>
                </div>
            </div>
        </div>

        <!-- Branding -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Branding</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Primary Color</label>
                    <input type="color" name="primary_color" value="<?php echo htmlspecialchars($settings['primary_color'] ?? '#C9A86A'); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Secondary Color</label>
                    <input type="color" name="secondary_color" value="<?php echo htmlspecialchars($settings['secondary_color'] ?? '#2D3748'); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Logo URL</label>
                    <input type="url" name="logo_url" value="<?php echo htmlspecialchars($settings['logo_url'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Favicon URL</label>
                    <input type="url" name="favicon_url" value="<?php echo htmlspecialchars($settings['favicon_url'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>
        </div>

        <!-- Booking Settings -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Booking Settings</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Cancellation Policy</label>
                    <textarea name="booking_cancellation_policy" rows="3"
                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($settings['booking_cancellation_policy'] ?? ''); ?></textarea>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Minimum Advance Hours</label>
                    <input type="number" name="booking_minimum_advance_hours" value="<?php echo htmlspecialchars($settings['booking_minimum_advance_hours'] ?? 2); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Maximum Advance Days</label>
                    <input type="number" name="booking_maximum_advance_days" value="<?php echo htmlspecialchars($settings['booking_maximum_advance_days'] ?? 90); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Buffer Before (minutes)</label>
                    <input type="number" name="booking_buffer_before_minutes" value="<?php echo htmlspecialchars($settings['booking_buffer_before_minutes'] ?? 0); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>
            <div class="mt-4">
                <div class="flex items-center">
                    <input type="checkbox" name="booking_reminder_24h" value="on" <?php echo ($settings['booking_reminder_24h'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Send 24-hour reminder</label>
                </div>
                <div class="flex items-center mt-2">
                    <input type="checkbox" name="booking_reminder_2h" value="on" <?php echo ($settings['booking_reminder_2h'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Send 2-hour reminder</label>
                </div>
            </div>
        </div>

        <!-- Notification Settings -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Notifications</h2>
            <div class="space-y-4">
                <div class="flex items-center">
                    <input type="checkbox" name="email_notifications" value="on" <?php echo ($settings['email_notifications'] ?? true) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Enable email notifications</label>
                </div>
                <div class="flex items-center">
                    <input type="checkbox" name="sms_notifications" value="on" <?php echo ($settings['sms_notifications'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Enable SMS notifications</label>
                </div>
                <div class="flex items-center">
                    <input type="checkbox" name="whatsapp_notifications" value="on" <?php echo ($settings['whatsapp_notifications'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Enable WhatsApp notifications</label>
                </div>
            </div>
        </div>

        <!-- SEO Settings -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">SEO Settings</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Default Title</label>
                    <input type="text" name="seo_title" value="<?php echo htmlspecialchars($settings['seo_title'] ?? 'Luxury Beauty Spa'); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Google Analytics ID</label>
                    <input type="text" name="google_analytics_id" value="<?php echo htmlspecialchars($settings['google_analytics_id'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>
        </div>

        <!-- Social Media -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Social Media</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Facebook URL</label>
                    <input type="url" name="facebook_url" value="<?php echo htmlspecialchars($settings['facebook_url'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Instagram URL</label>
                    <input type="url" name="instagram_url" value="<?php echo htmlspecialchars($settings['instagram_url'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Twitter URL</label>
                    <input type="url" name="twitter_url" value="<?php echo htmlspecialchars($settings['twitter_url'] ?? ''); ?>"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>
        </div>

        <!-- Advanced Settings -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-semibold mb-4">Advanced Settings</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Timezone</label>
                    <select name="timezone" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <?php
                        $currentTimezone = $settings['timezone'] ?? 'UTC';
                        $timezones = ['UTC', 'America/New_York', 'America/Los_Angeles', 'Europe/London', 'Asia/Tokyo'];
                        foreach ($timezones as $tz) {
                            echo '<option value="' . $tz . '" ' . ($tz === $currentTimezone ? 'selected' : '') . '>' . $tz . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Language</label>
                    <select name="language" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <?php
                        $currentLang = $settings['language'] ?? 'en';
                        $languages = ['en' => 'English', 'es' => 'Spanish', 'fr' => 'French'];
                        foreach ($languages as $code => $name) {
                            echo '<option value="' . $code . '" ' . ($code === $currentLang ? 'selected' : '') . '>' . $name . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="mt-4">
                <div class="flex items-center">
                    <input type="checkbox" name="maintenance_mode" value="on" <?php echo ($settings['maintenance_mode'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Enable maintenance mode</label>
                </div>
                <div class="flex items-center mt-2">
                    <input type="checkbox" name="debug_mode" value="on" <?php echo ($settings['debug_mode'] ?? false) ? 'checked' : ''; ?>
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <label class="ml-2 text-sm text-gray-700">Enable debug mode</label>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Save Settings
            </button>
        </div>
    </form>
</div>
