<?php
/**
 * Admin Services Index View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Services Management</h1>
        <a href="<?php echo BASE_URL; ?>/admin/services/create" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
            Add New Service
        </a>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <!-- Filters -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700">Category</label>
                <select name="category" onchange="this.form.submit()" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Categories</option>
                    <?php foreach ($categories ?? [] as $category): ?>
                        <option value="<?php echo $category['id']; ?>" <?php echo ($filters['category'] ?? '') == $category['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($category['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Status</label>
                <select name="status" onchange="this.form.submit()" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="all" <?php echo ($filters['status'] ?? 'all') === 'all' ? 'selected' : ''; ?>>All Statuses</option>
                    <option value="active" <?php echo ($filters['status'] ?? '') === 'active' ? 'selected' : ''; ?>>Active</option>
                    <option value="inactive" <?php echo ($filters['status'] ?? '') === 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Search</label>
                <input type="text" name="search" value="<?php echo htmlspecialchars($filters['search'] ?? ''); ?>" placeholder="Service name..."
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                    Filter
                </button>
                <a href="<?php echo BASE_URL; ?>/admin/services" class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                    Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Services Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if (empty($services ?? [])): ?>
            <div class="col-span-full text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No services found</h3>
                <p class="mt-1 text-sm text-gray-500">Get started by creating your first service.</p>
                <div class="mt-6">
                    <a href="<?php echo BASE_URL; ?>/admin/services/create" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                        Add New Service
                    </a>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($services as $service): ?>
                <div class="bg-white shadow rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                    <div class="aspect-w-16 aspect-h-9 bg-gray-200">
                        <?php if ($service['image']): ?>
                            <img src="<?php echo htmlspecialchars($service['image']); ?>" alt="<?php echo htmlspecialchars($service['name']); ?>"
                                 class="w-full h-48 object-cover">
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-indigo-100 to-purple-100 flex items-center justify-center">
                                <svg class="w-16 h-16 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="p-6">
                        <div class="flex justify-between items-start mb-2">
                            <h3 class="text-lg font-semibold text-gray-900">
                                <?php echo htmlspecialchars($service['name']); ?>
                            </h3>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                <?php echo $service['is_active'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                <?php echo $service['is_active'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </div>

                        <p class="text-gray-600 text-sm mb-3"><?php echo htmlspecialchars(substr($service['description'], 0, 100)); ?>...</p>

                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <span class="text-2xl font-bold text-gray-900">$<?php echo number_format($service['price'], 2); ?></span>
                                <span class="text-sm text-gray-500"> • <?php echo $service['duration_minutes']; ?> min</span>
                            </div>
                        </div>

                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-500"><?php echo htmlspecialchars($service['category_name'] ?? 'Uncategorized'); ?></span>
                            <div class="flex space-x-2">
                                <a href="<?php echo BASE_URL; ?>/admin/services/<?php echo $service['id']; ?>" class="text-indigo-600 hover:text-indigo-800 text-sm">
                                    View
                                </a>
                                <a href="<?php echo BASE_URL; ?>/admin/services/<?php echo $service['id']; ?>/edit" class="text-blue-600 hover:text-blue-800 text-sm">
                                    Edit
                                </a>
                                <button onclick="toggleStatus(<?php echo $service['id']; ?>, <?php echo $service['is_active'] ? 'false' : 'true'; ?>)" class="text-sm <?php echo $service['is_active'] ? 'text-orange-600 hover:text-orange-800' : 'text-green-600 hover:text-green-800'; ?>">
                                    <?php echo $service['is_active'] ? 'Deactivate' : 'Activate'; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if (($pagination['total_pages'] ?? 1) > 1): ?>
        <div class="mt-8 flex justify-center">
            <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px">
                <?php if (($pagination['current_page'] ?? 1) > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => ($pagination['current_page'] ?? 1) - 1])); ?>"
                       class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                        Previous
                    </a>
                <?php endif; ?>

                <?php for ($i = max(1, ($pagination['current_page'] ?? 1) - 2); $i <= min($pagination['total_pages'] ?? 1, ($pagination['current_page'] ?? 1) + 2); $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>"
                       class="relative inline-flex items-center px-4 py-2 border border-gray-300 bg-white text-sm font-medium <?php echo $i === ($pagination['current_page'] ?? 1) ? 'text-indigo-600 bg-indigo-50' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>

                <?php if (($pagination['current_page'] ?? 1) < ($pagination['total_pages'] ?? 1)): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => ($pagination['current_page'] ?? 1) + 1])); ?>"
                       class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                        Next
                    </a>
                <?php endif; ?>
            </nav>
        </div>
    <?php endif; ?>
</div>

<script>
function toggleStatus(serviceId, activate) {
    const action = activate ? 'activate' : 'deactivate';
    if (!confirm(`Are you sure you want to ${action} this service?`)) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/admin/services/${serviceId}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'Failed to update service status');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to update service status');
    });
}
</script>
