<?php
/**
 * Admin Bookings Show View
 * Salon/Spa/Beauty Parlor Booking System
 */
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Booking Details</h1>
        <div class="flex space-x-4">
            <a href="<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>/edit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                Edit Booking
            </a>
            <a href="<?php echo BASE_URL; ?>/admin/bookings" class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                Back to Bookings
            </a>
        </div>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            <?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Booking Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Booking Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Booking Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Booking Number</label>
                        <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo htmlspecialchars($booking['booking_number']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Status</label>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full mt-1
                            <?php echo $booking['status'] === 'confirmed' ? 'bg-blue-100 text-blue-800' :
                                ($booking['status'] === 'completed' ? 'bg-green-100 text-green-800' :
                                ($booking['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                ($booking['status'] === 'cancelled' ? 'bg-red-100 text-red-800' :
                                'bg-gray-100 text-gray-800'))); ?>">
                            <?php echo ucfirst($booking['status']); ?>
                        </span>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Service</label>
                        <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($booking['service_name']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Duration</label>
                        <p class="mt-1 text-gray-900"><?php echo $booking['duration_minutes']; ?> minutes</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Date & Time</label>
                        <p class="mt-1 text-gray-900"><?php echo formatDateTime($booking['start_at']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Branch</label>
                        <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($booking['branch_name']); ?></p>
                    </div>
                    <?php if ($booking['staff_first_name']): ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Staff Member</label>
                            <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($booking['staff_first_name'] . ' ' . $booking['staff_last_name']); ?></p>
                        </div>
                    <?php endif; ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Total Amount</label>
                        <p class="mt-1 text-xl font-bold text-gray-900">$<?php echo number_format($booking['total_amount'], 2); ?></p>
                    </div>
                </div>

                <?php if ($booking['notes']): ?>
                    <div class="mt-4">
                        <label class="block text-sm font-medium text-gray-700">Notes</label>
                        <p class="mt-1 text-gray-600 bg-gray-50 p-3 rounded"><?php echo nl2br(htmlspecialchars($booking['notes'])); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Customer Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Customer Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Name</label>
                        <p class="mt-1 text-gray-900"><?php echo htmlspecialchars($booking['first_name'] . ' ' . $booking['last_name']); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Email</label>
                        <p class="mt-1 text-gray-900">
                            <a href="mailto:<?php echo htmlspecialchars($booking['email']); ?>" class="text-indigo-600 hover:text-indigo-800">
                                <?php echo htmlspecialchars($booking['email']); ?>
                            </a>
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Phone</label>
                        <p class="mt-1 text-gray-900">
                            <a href="tel:<?php echo htmlspecialchars($booking['phone']); ?>" class="text-indigo-600 hover:text-indigo-800">
                                <?php echo htmlspecialchars($booking['phone']); ?>
                            </a>
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Customer Type</label>
                        <p class="mt-1 text-gray-900"><?php echo $booking['customer_id'] ? 'Registered Customer' : 'Guest'; ?></p>
                    </div>
                </div>

                <?php if ($booking['customer_id']): ?>
                    <div class="mt-4">
                        <a href="<?php echo BASE_URL; ?>/admin/customers/<?php echo $booking['customer_id']; ?>" class="text-indigo-600 hover:text-indigo-800">
                            View Customer Profile →
                        </a>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Payment Information -->
            <?php if (!empty($payments ?? [])): ?>
                <div class="bg-white shadow rounded-lg p-6">
                    <h2 class="text-xl font-semibold mb-4">Payment Information</h2>
                    <div class="space-y-4">
                        <?php foreach ($payments as $payment): ?>
                            <div class="border rounded-lg p-4">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <p class="font-medium">Transaction #<?php echo htmlspecialchars($payment['transaction_id'] ?? $payment['id']); ?></p>
                                        <p class="text-sm text-gray-600">
                                            <?php echo htmlspecialchars($payment['payment_method_name'] ?? 'Unknown Method'); ?> •
                                            <?php echo formatDateTime($payment['created_at']); ?>
                                        </p>
                                    </div>
                                    <div class="text-right">
                                        <p class="font-bold text-lg">$<?php echo number_format($payment['amount'], 2); ?></p>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo $payment['status'] === 'completed' ? 'bg-green-100 text-green-800' :
                                                ($payment['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                                'bg-red-100 text-red-800'); ?>">
                                            <?php echo ucfirst($payment['status']); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Booking Notes/History -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-semibold mb-4">Booking History</h2>
                <div class="space-y-4">
                    <?php
                    $history = $history ?? [
                        ['action' => 'Booking Created', 'user' => 'System', 'timestamp' => $booking['created_at'], 'details' => 'Initial booking creation'],
                        ['action' => 'Status Changed', 'user' => 'Admin', 'timestamp' => $booking['updated_at'], 'details' => 'Status set to ' . ucfirst($booking['status'])]
                    ];
                    foreach ($history as $event): ?>
                        <div class="flex items-start space-x-3">
                            <div class="flex-shrink-0">
                                <div class="w-2 h-2 bg-blue-500 rounded-full mt-2"></div>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($event['action']); ?></p>
                                <p class="text-sm text-gray-600"><?php echo htmlspecialchars($event['details']); ?></p>
                                <p class="text-xs text-gray-500">
                                    <?php echo htmlspecialchars($event['user']); ?> •
                                    <?php echo formatDateTime($event['timestamp']); ?>
                                </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Sidebar Actions -->
        <div class="space-y-6">
            <!-- Quick Actions -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Quick Actions</h3>
                <div class="space-y-3">
                    <?php if ($booking['status'] === 'pending'): ?>
                        <button onclick="updateStatus('confirmed')" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                            Confirm Booking
                        </button>
                    <?php endif; ?>

                    <?php if ($booking['status'] === 'confirmed'): ?>
                        <button onclick="updateStatus('completed')" class="w-full bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700">
                            Mark as Completed
                        </button>
                    <?php endif; ?>

                    <?php if (in_array($booking['status'], ['pending', 'confirmed'])): ?>
                        <button onclick="updateStatus('cancelled')" class="w-full bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700">
                            Cancel Booking
                        </button>
                    <?php endif; ?>

                    <button onclick="printBooking()" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                        Print Receipt
                    </button>
                </div>
            </div>

            <!-- Send Notification -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Send Notification</h3>
                <div class="space-y-3">
                    <button onclick="sendReminder()" class="w-full bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">
                        Send Reminder
                    </button>
                    <button onclick="sendConfirmation()" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                        Send Confirmation
                    </button>
                </div>
            </div>

            <!-- Booking Timeline -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold mb-4">Timeline</h3>
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span>Created:</span>
                        <span><?php echo formatDateTime($booking['created_at']); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Last Updated:</span>
                        <span><?php echo formatDateTime($booking['updated_at']); ?></span>
                    </div>
                    <?php if ($booking['start_at'] > date('Y-m-d H:i:s')): ?>
                        <div class="flex justify-between">
                            <span>Time Until:</span>
                            <span><?php
                                $diff = strtotime($booking['start_at']) - time();
                                $hours = floor($diff / 3600);
                                $minutes = floor(($diff % 3600) / 60);
                                echo $hours . 'h ' . $minutes . 'm';
                            ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function updateStatus(status) {
    if (!confirm(`Are you sure you want to ${status === 'cancelled' ? 'cancel' : status === 'completed' ? 'complete' : 'confirm'} this booking?`)) {
        return;
    }

    fetch(`<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>/status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `status=${status}&csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'Failed to update status');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to update status');
    });
}

function printBooking() {
    window.open(`<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>/print`, '_blank');
}

function sendReminder() {
    fetch(`<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>/send-reminder`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Reminder sent successfully');
        } else {
            alert(data.message || 'Failed to send reminder');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to send reminder');
    });
}

function sendConfirmation() {
    fetch(`<?php echo BASE_URL; ?>/admin/bookings/<?php echo $booking['id']; ?>/send-confirmation`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `csrf_token=<?php echo csrf_token(); ?>`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Confirmation sent successfully');
        } else {
            alert(data.message || 'Failed to send confirmation');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to send confirmation');
    });
}
</script>
