<?php
/**
 * Home Controller
 * Salon/Spa/Beauty Parlor Booking System
 */

class HomeController extends Controller {
    public function index() {
        // Get company info (for now, use the first active company)
        $company = $this->db->query("SELECT * FROM companies WHERE status = 'active' LIMIT 1")->single();

        if (!$company) {
            // Show setup message
            $this->view('setup');
            return;
        }

        // Get featured services
        $serviceModel = new Service();
        $featuredServices = $serviceModel->getFeatured($company['id'], 6);

        // Get service categories
        $categories = $this->db->query("
            SELECT * FROM service_categories
            WHERE (company_id = ? OR company_id IS NULL) AND is_active = 1
            ORDER BY sort_order ASC, name ASC
        ")->bind(1, $company['id'])->resultSet();

        // Get branches
        $branches = $this->db->query("
            SELECT * FROM branches
            WHERE company_id = ? AND status = 'active'
            ORDER BY is_main DESC, name ASC
        ")->bind(1, $company['id'])->resultSet();

        // Get testimonials (placeholder for now)
        $testimonials = [
            [
                'name' => 'Sarah Johnson',
                'review' => 'Amazing service! The staff is professional and the results are outstanding.',
                'rating' => 5
            ],
            [
                'name' => 'Mike Davis',
                'review' => 'Luxury experience at affordable prices. Highly recommend!',
                'rating' => 5
            ]
        ];

        $this->view('home/index', [
            'company' => $company,
            'featuredServices' => $featuredServices,
            'categories' => $categories,
            'branches' => $branches,
            'testimonials' => $testimonials
        ]);
    }
}
