<?php
/**
 * Main Entry Point
 * Salon/Spa/Beauty Parlor Booking System
 */

// Include configuration
require_once __DIR__ . '/../config/config.php';

// Start output buffering
ob_start();

// Handle errors
if (IS_DEVELOPMENT) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// Set headers
header('Content-Type: text/html; charset=UTF-8');
header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');

// CSRF protection for POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST[CSRF_TOKEN_NAME]) || !verifyCsrfToken($_POST[CSRF_TOKEN_NAME])) {
        http_response_code(403);
        die('CSRF token validation failed');
    }
}

// Initialize authentication
$auth = Auth::getInstance();

// Initialize router
$router = new Router();

// Load routes
require_once SRC_PATH . '/routes.php';

// Dispatch request
try {
    $router->dispatch();
} catch (Exception $e) {
    if (IS_DEVELOPMENT) {
        echo '<h1>Error</h1>';
        echo '<pre>' . $e->getMessage() . '</pre>';
        echo '<pre>' . $e->getTraceAsString() . '</pre>';
    } else {
        error_log($e->getMessage());
        http_response_code(500);
        include PUBLIC_PATH . '/500.php';
    }
}

// End output buffering
ob_end_flush();
