<?php
/**
 * Main Configuration File
 * Salon/Spa/Beauty Parlor Booking System
 */

// Environment detection
define('ENVIRONMENT', getenv('APP_ENV') ?: 'development');
define('IS_PRODUCTION', ENVIRONMENT === 'production');
define('IS_DEVELOPMENT', ENVIRONMENT === 'development');

// Base paths
define('ROOT_PATH', dirname(__DIR__));
define('CONFIG_PATH', __DIR__);
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('SRC_PATH', ROOT_PATH . '/src');
define('ASSETS_PATH', PUBLIC_PATH . '/assets');
define('UPLOADS_PATH', PUBLIC_PATH . '/uploads');

// URL Configuration
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$baseUrl = getenv('APP_URL') ?: $protocol . '://' . $host;

define('BASE_URL', rtrim($baseUrl, '/'));
define('ASSETS_URL', BASE_URL . '/assets');
define('UPLOADS_URL', BASE_URL . '/uploads');

// Database Configuration
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_NAME', getenv('DB_NAME') ?: 'salon_system');
define('DB_USER', getenv('DB_USER') ?: 'root');
define('DB_PASS', getenv('DB_PASS') ?: '');
define('DB_CHARSET', 'utf8mb4');

// Security Configuration
define('CSRF_TOKEN_NAME', 'csrf_token');
define('SESSION_NAME', 'salon_session');
define('SESSION_LIFETIME', 7200); // 2 hours

// File Upload Configuration
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);
define('ALLOWED_FILE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'application/pdf']);

// Booking Configuration
define('DEFAULT_TIMEZONE', 'UTC');
define('BOOKING_TIME_SLOT', 15); // minutes
define('MAX_ADVANCE_BOOKING_DAYS', 90);
define('MIN_ADVANCE_BOOKING_HOURS', 2);

// Pagination
define('ITEMS_PER_PAGE', 20);
define('ADMIN_ITEMS_PER_PAGE', 50);

// Cache Configuration
define('CACHE_ENABLED', getenv('CACHE_ENABLED') ?: false);
define('CACHE_TTL', 3600); // 1 hour

// Email Configuration
define('SMTP_HOST', getenv('SMTP_HOST') ?: '');
define('SMTP_PORT', getenv('SMTP_PORT') ?: 587);
define('SMTP_USER', getenv('SMTP_USER') ?: '');
define('SMTP_PASS', getenv('SMTP_PASS') ?: '');
define('SMTP_ENCRYPTION', getenv('SMTP_ENCRYPTION') ?: 'tls');
define('FROM_EMAIL', getenv('FROM_EMAIL') ?: 'noreply@salon.com');
define('FROM_NAME', getenv('FROM_NAME') ?: 'Salon System');

// WhatsApp Configuration (Business API)
define('WHATSAPP_ACCESS_TOKEN', getenv('WHATSAPP_ACCESS_TOKEN') ?: '');
define('WHATSAPP_PHONE_NUMBER_ID', getenv('WHATSAPP_PHONE_NUMBER_ID') ?: '');
define('WHATSAPP_BUSINESS_ACCOUNT_ID', getenv('WHATSAPP_BUSINESS_ACCOUNT_ID') ?: '');

// M-Pesa Configuration
define('MPESA_CONSUMER_KEY', getenv('MPESA_CONSUMER_KEY') ?: '');
define('MPESA_CONSUMER_SECRET', getenv('MPESA_CONSUMER_SECRET') ?: '');
define('MPESA_SHORTCODE', getenv('MPESA_SHORTCODE') ?: '');
define('MPESA_PASSKEY', getenv('MPESA_PASSKEY') ?: '');
define('MPESA_ENVIRONMENT', getenv('MPESA_ENVIRONMENT') ?: 'sandbox');

// Social Media
define('FACEBOOK_URL', getenv('FACEBOOK_URL') ?: '');
define('INSTAGRAM_URL', getenv('INSTAGRAM_URL') ?: '');
define('TWITTER_URL', getenv('TWITTER_URL') ?: '');

// PWA Configuration
define('PWA_ENABLED', true);
define('PWA_NAME', 'Salon Booking System');
define('PWA_SHORT_NAME', 'Salon App');
define('PWA_DESCRIPTION', 'Book beauty services online');
define('PWA_THEME_COLOR', '#C9A86A');
define('PWA_BACKGROUND_COLOR', '#ffffff');

// Error Reporting
if (IS_DEVELOPMENT) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set(DEFAULT_TIMEZONE);

// Autoloader
spl_autoload_register(function ($class) {
    // Convert namespace to file path
    $class = str_replace('\\', '/', $class);
    $file = SRC_PATH . '/' . $class . '.php';

    if (file_exists($file)) {
        require_once $file;
    }
});

// Include helper functions
require_once CONFIG_PATH . '/functions.php';
